package com.pcloud.book.book.constant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import com.pcloud.common.constant.CacheConstant;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 描述 :图书常量
 *
 * @author 作者: lili
 * @version 1.0
 * @date 创建时间：2017年7月18日 上午10:02:36
 */
public class BookConstant {

    /**
     * 微信小号每天拉人次数缓存前缀
     */
    public static final String WXGROUP_ADD_USER_NUM = CacheConstant.BOOK + "WXGROUP_ADD_USER_NUM:";

    /**
     * 图书基础缓存前缀名称
     */
    public static final String BOOK_CACHE = CacheConstant.BOOK + "BOOK:";

    /**
     * 图书缓存时间60分钟
     */
    public static final Integer BOOK_CACHE_SECOUND = 3600;

    /**
     * 图书基础缓存前缀名称
     */
    public static final String BOOK_ISBN_CACHE = CacheConstant.BOOK + "ISBN:";

    /**
     * 图书应用关联缓存前缀名称
     */
    public static final String BOOK_APP_CACHE = CacheConstant.BOOK + "BOOK_APP:";

    /**
     * 图书商品关联缓存前缀名称
     */
    public static final String BOOK_PRODUCT_CACHE = CacheConstant.BOOK + "BOOK_PRODUCT:";

    /**
     * 图书资源关联缓存前缀名称
     */
    public static final String BOOK_RESOURCE_CACHE = CacheConstant.BOOK + "BOOK_RESOURCE:";

    /**
     * 图书缓存时间1天
     */
    public static final Integer BOOK_CACHE_ONE_DAY = 60 * 60 * 24;

    /**
     * 图书缓存时间1月
     */
    public static final Integer BOOK_CACHE_ONE_MONTH = 60 * 60 * 24 * 30;

    /**
     * 图书编辑状态 1已删除
     */
    public static final Integer BOOK_ADVISER_DELETE = 1;

    /**
     * 图书编辑状态 0未删除
     */
    public static final Integer BOOK_ADVISER_NO_DELETE = 0;

    /**
     * 图书应用关系 1删除
     */
    public static final Integer BOOK_APP_DELETE = 1;

    /**
     * 图书应用关系 0未删除
     */
    public static final Integer BOOK_APP_NO_DELETE = 0;

    /**
     * 主編輯
     */
    public static final Integer MAIN_ADVISER = 1;

    /**
     * 副編輯
     */
    public static final Integer VICE_ADVISER = 0;

    /**
     * 默认图书isbn
     */
    public static final String DEFAULT_BOOK_ISBN = "9787507600000";

    /**
     * 图书查询个数
     */
    public static final Integer BOOK_SELECT_COUNT = 500;

    /**
     * 主编辑
     */
    public static final Integer MAIN_EDITOR = 1;

    /**
     * 副编辑
     */
    public static final Integer NOT_MAIN_EDITOR = 0;
    /**
     * 7天
     */
    public static final Long SEVEN = 7L;
    /**
     * 15天
     */
    public static final Long FIFTEEN = 15L;
    /**
     * 30天
     */
    public static final Long THIRTY = 30L;

    /**
     * 微信群默认头像
     */
    public static final List<String> DEFAULT_HEADURL =Arrays.asList(
            "https://oss.5rs.me/oss/upload/image/jpg/fd9e019d8c6d4a5a84769d69932f32a0.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/e7fbe5cfb8e74eebad610091b2d90941.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/4b450a1c244a4c2a83e5bb83749eecd2.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/8fa48b32e4f845ee8174bcf70c4d6d1a.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5c2af3517a6941feaa278c23e85db16f.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/d8413818004b43c3af489ca6e249ae31.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/05d98267b99441f2be54d5c4b39c99e1.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a5ff33889b4945bd94f7bfc8216bc0d8.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/3fb33c317d7f48df93109571957959fa.jpg");

    public enum BookKeywordAuditEnum {

        NORMAL(0),
        /**
         * 待审核
         */
        TO_AUDIT(1),
        /**
         * 审核通过
         */
        PASS_THE_AUDIT(2),
        /**
         * 拒绝审核
         */
        REFUSE_THE_AUDIT(3);

        private Integer code;

        BookKeywordAuditEnum(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }

    public static final Map<Integer, BookKeywordAuditEnum> AUDIT_ENUM_MAP = Maps.newHashMap();

    static {
        for (BookKeywordAuditEnum auditEnum : Lists.newArrayList(BookKeywordAuditEnum.values())) {
            AUDIT_ENUM_MAP.put(auditEnum.getCode(), auditEnum);
        }
    }

    public enum BookKeywordScopeEnum {
        /**
         * 全部
         */
        ALL(0),
        /**
         * 编辑
         */
        EDITOR(1);

        private Integer code;

        BookKeywordScopeEnum(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }

}
