package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.BookGroupServeDao;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/23 15:39
 **/
@Component("bookGroupServeDao")
public class BookGroupServeDaoImpl extends BaseDaoImpl<BookGroupServe> implements BookGroupServeDao {
    @Override
    public Integer batchInsert(List<BookGroupServe> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public List<BookGroupServe> getListByBookGroupId(Long bookGroupId) {
        return super.getSqlSession().selectList(getStatement("getListByBookGroupId"), bookGroupId);
    }

    @Override
    public void deleteByBookGroupId(Long bookGroupId) {
        super.getSqlSession().delete(getStatement("deleteByBookGroupId"), bookGroupId);
    }

    @Override
    public List<BookGroupServe> getListByServerType(String serveType) {
        return super.getSqlSession().selectList(getStatement("getListByServerType"), serveType);
    }

    @Override
    public void updateShortUrl(Long id, String shortUrl) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        map.put("shortUrl", shortUrl);
        super.getSqlSession().update(getStatement("updateShortUrl"), map);
    }
}
