package com.pcloud.book.personal.facade;

import com.pcloud.book.personal.biz.PersonalMedalBiz;
import com.pcloud.book.personal.enums.StarReceiveTypeEnum;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api("个人中心勋章")
@RestController("personalMedalFacade")
@RequestMapping("personalMedal")
public class PersonalMedalFacade {

    @Autowired
    private PersonalMedalBiz personalMedalBiz;

    @ApiOperation("勋章基础展示列表")
    @GetMapping("getBaseMedalList")
    public ResponseDto<?> getBaseMedalList() throws PermissionException {
        return new ResponseDto<>(personalMedalBiz.getBaseMedalList());
    }

    @ApiOperation("获取用户已获得的勋章")
    @GetMapping("getUserMedalList")
    public ResponseDto<?> getUserMedalList(@CookieValue("userInfo") String userInfo) throws PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(personalMedalBiz.getUserMedalList(wechatUserId));
    }

    @ApiOperation("获取用户已获得的勋章")
    @GetMapping("getUserMedalListCount")
    public ResponseDto<?> getUserMedalListCount(@CookieValue("userInfo") String userInfo) throws PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(personalMedalBiz.getUserMedalList(wechatUserId).size());
    }

    @ApiOperation("登录获取勋章")
    @GetMapping("loginReceiveStar")
    public ResponseDto<?> loginReceiveStar(@CookieValue("userInfo") String userInfo) throws PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        personalMedalBiz.loginReceiveStar(wechatUserId);
        return new ResponseDto<>();
    }

    @ApiOperation("用户已领取的星星数量")
    @GetMapping("getReceiveStarCount")
    public ResponseDto<?> getReceiveStarCount(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(personalMedalBiz.getReceiveStarCount(wechatUserId));
    }

    @ApiOperation("更新勋章为已展示")
    @GetMapping("updateMedalShowed")
    public ResponseDto<?> updateMedalShowed(@CookieValue("userInfo") String userInfo,@RequestParam Long medalRecordId){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        personalMedalBiz.updateMedalShowed(medalRecordId);
        return new ResponseDto<>();
    }

    @ApiOperation("领取基础资料星星")
    @GetMapping("receiveStar4BaseInfo")
    public ResponseDto<?> receiveStar4BaseInfo(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        personalMedalBiz.receiveStar(wechatUserId, StarReceiveTypeEnum.BASE_INFO);
        return new ResponseDto<>();
    }

    @ApiOperation("分享")
    @GetMapping("shareMedal")
    public ResponseDto<?> shareMedal(@CookieValue("userInfo") String userInfo, @RequestParam String robotWxId){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(personalMedalBiz.shareMedal(wechatUserId, robotWxId));
    }

    @ApiOperation("获取排名")
    @GetMapping("getRanking")
    public ResponseDto<?> getRanking(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(personalMedalBiz.getRanking(wechatUserId));
    }

    @ApiOperation("获取陪伴天数")
    @GetMapping("getLoginDays")
    public ResponseDto<?> getLoginDays(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(personalMedalBiz.getLoginDays(wechatUserId));
    }


    @ApiOperation("获取勋章陪伴总天数")
    @GetMapping("getMedalAllDays")
    public ResponseDto<?> getMedalAllDays(@CookieValue("userInfo") String userInfo,@RequestParam Integer medalDays){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(personalMedalBiz.getMedalAllDays(wechatUserId,medalDays));
    }



}
