package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.entity.PersonalStageProgressMessage;
import com.pcloud.book.personalstage.dao.PersonalStageProgressMessageDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * (PersonalStageProgressMessage)表数据库访问层
 *
 * @author zyq
 * @since 2020-02-24 15:57:48
 */
@Repository("personalStageProgressMessageDaoImpl")
public class PersonalStageProgressMessageDaoImpl extends BaseDaoImpl<PersonalStageProgressMessage> implements PersonalStageProgressMessageDao {

    @Override
    public List<PersonalStageProgressMessage> getPersonalProgress(Date startTime) {
        return getSessionTemplate().selectList(getStatement("getPersonalProgress"),startTime);
    }

    @Override
    public List<PersonalStageProgressMessage> getProgressMessageList() {
        return getSessionTemplate().selectList(getStatement("getProgressMessageList"));
    }

    @Override
    public void deleteAll() {
        super.getSessionTemplate().delete(getStatement("deleteAll"));
    }

    @Override
    public Integer countProgressMessage() {
        return super.sqlSessionTemplate.selectOne(getStatement("countProgressMessage"));
    }
}