package com.pcloud.book.push.biz;

import com.pcloud.book.group.vo.UserBookInfoVO;
import com.pcloud.book.push.dto.SelfPushAddParamDTO;
import com.pcloud.book.push.dto.SelfPushRecordDTO;
import com.pcloud.book.push.entity.SelfPush;
import com.pcloud.common.page.PageBeanNew;

/**
 * @描述：个人号群发
 * @作者：zhuyajie
 * @创建时间：11:00 2019/11/27
 * @版本：1.0
 */
public interface SelfPushBiz {
    /**
     * 创建群发
     * @param partyId
     * @param addParamDTO
     */
    void createSelfPush(Long partyId, SelfPushAddParamDTO addParamDTO);

    /**
     * 群发记录用户列表
     * @param pushId
     * @return
     */
    PageBeanNew<UserBookInfoVO> listSelfPushUser(Long pushId, Integer currentPage,Integer numPerPage);

    /**
     * 个人号群发记录列表
     * @param currentPage
     * @param numPerPage
     * @param startTime
     * @param endTime
     * @return
     */
    PageBeanNew<SelfPushRecordDTO> listSelfPushRecord(Integer currentPage, Integer numPerPage, String startTime, String endTime, Integer status,Long partyId);

    /**
     * 定时任务触发群发
     * @param pushId
     */
    void sendSelfMsgQuartz(Long pushId);

    /**
     * 根据pushId删除
     * @param pushId
     */
    void deleteByPushId(Long pushId);

    /**
     * 复制配置到另一个小号
     * @param originRobot
     * @param targetRobot
     */
    void  copyRobotData(String originRobot, String targetRobot);

    /**
     * 修改个人号群发
     */
    void updateSelfPush(Long partyId, SelfPushAddParamDTO addParamDTO);

    SelfPush getSelfPush(Long pushId);
}
