package com.pcloud.book.timecontrol.facade.impl;

import com.pcloud.book.timecontrol.biz.BookTaskBindingBiz;
import com.pcloud.book.timecontrol.vo.BookTaskBindingAddVO;
import com.pcloud.book.timecontrol.vo.BookTaskBindingVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 书刊与任务模板绑定关联关系 外部接口
 *
 * @author Gui_q
 * @since 2020年1月30日 14点36分
 */
@Api(tags = "任务配置发布 外部接口")
@RequestMapping(value = "/bookTaskBinding")
@RestController("bookTaskBindingFacadeImpl")
public class BookTaskBindingFacade {

    @Autowired
    private BookTaskBindingBiz bookTaskBindingBiz;


    @ApiOperation(value = "获取任务配置发布列表", httpMethod = "GET")
    @RequestMapping(value = "/listBookTaskBinding4Pcloud", method = RequestMethod.GET)
    ResponseDto<PageBeanNew<BookTaskBindingVO>> listBookTaskBinding4Pcloud(@RequestHeader("token") String token,
                                                                           @RequestParam(value = "book", required = false) String book,
                                                                           @RequestParam(value = "proLabelId", required = false) Integer proLabelId,
                                                                           @RequestParam(value = "depLabelId", required = false) Integer depLabelId,
                                                                           @RequestParam(value = "purLabelId", required = false) Integer purLabelId,
                                                                           @RequestParam("currentPage") Integer currentPage,
                                                                           @RequestParam("numPerPage") Integer numPerPage) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        PageBeanNew<BookTaskBindingVO> result = bookTaskBindingBiz.listBookTaskBinding4Pcloud(book, proLabelId, depLabelId, purLabelId, currentPage, numPerPage);
        return new ResponseDto<>(result);
    }


    @ApiOperation(value = "批量开启任务", httpMethod = "POST")
    @RequestMapping(value = "/batchStartTask", method = RequestMethod.POST)
    ResponseDto<?> batchStartTask(@RequestHeader("token") String token,
                                  @RequestBody List<Integer> ids) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        bookTaskBindingBiz.batchUpdateBookTaskState(ids, 1);
        return new ResponseDto<>(null);
    }

    @ApiOperation(value = "批量关闭任务", httpMethod = "POST")
    @RequestMapping(value = "/batchCloseTask", method = RequestMethod.POST)
    ResponseDto<?> batchCloseTask(@RequestHeader("token") String token,
                                  @RequestBody List<Integer> ids) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        bookTaskBindingBiz.batchUpdateBookTaskState(ids, 0);
        return new ResponseDto<>(null);
    }


    @ApiOperation(value = "批量删除任务", httpMethod = "POST")
    @RequestMapping(value = "/batchDeleteTask", method = RequestMethod.POST)
    ResponseDto<?> batchDeleteTask(@RequestHeader("token") String token,
                                   @RequestBody List<Integer> ids) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        bookTaskBindingBiz.batchDeleteBookTask(ids);
        return new ResponseDto<>(null);
    }


    @ApiOperation(value = "创建任务关联书刊", httpMethod = "POST")
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    ResponseDto<?> create(@RequestHeader("token") String token,
                          @RequestBody BookTaskBindingAddVO bookTaskBindingAddVO) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        bookTaskBindingBiz.create(bookTaskBindingAddVO);
        return new ResponseDto<>(null);
    }
}
