package com.pcloud.book.rightsSetting.biz;

import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.entity.AppletUserBookcase;
import com.pcloud.book.rightsSetting.dto.FillRightsSettingAppletsDTO;
import com.pcloud.book.rightsSetting.dto.RightsSettingDto;
import com.pcloud.book.rightsSetting.dto.RightsSettingShowStateDTO;
import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import com.pcloud.book.rightsSetting.entity.RightsItemGroup;
import com.pcloud.book.rightsSetting.entity.RightsNowPic;
import com.pcloud.book.rightsSetting.entity.RightsSetting;
import com.pcloud.book.rightsSetting.entity.RightsSettingClassify;
import com.pcloud.book.rightsSetting.entity.RightsSettingItem;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

public interface RightsSettingBiz {
    Long addRightsSetting(RightsSetting rightsSetting);

    void setClassifyAndLabel(BaseTempletClassify baseTempletClassify);

    void deleteRightsSetting(Long id);

    void updateRightsSetting(RightsSetting rightsSetting);

    RightsSetting getRightsSetting(Long id);

    PageBeanNew<RightsSettingDto> listRightsSettingPage(Integer currentPage, Integer numPerPage, RightsSetting rightsSetting);

    RightsSettingDto getByLabel(Long firstClassify,Long secondClassify,Long gradeLabelId,Long subjectLabelId, Long volLabelId, Long verLabelId);

    Integer getUserCount();

    /**
     * 批量新增每周/长期权益
     * @param rightsSettingItemList
     * @param rightsSettingId
     */
    void batchInsertRightsSettingItem(List<RightsSettingItem> rightsSettingItemList, Long rightsSettingId,String rightsType);

    /**
     * 每周/长期权益查询
     * @param rightsSettingId
     * @param rightsType
     * @return
     */
    List<RightsSettingItem> getItemsByRightsSettingId(Long rightsSettingId, String rightsType, Integer readType);

    /**
     * 小程序首页权益查询
     * @param bookId
     * @param adviserId
     * @param channelId
     * @return
     */
    RightsSettingDto getRightsSettingByBookId4AppletHome(Long bookId, Long adviserId, Long channelId);

    /**
     * 小程序首页本周/长期权益查询
     * @param rightsSettingId
     * @param wechatUserId
     * @param rightsType
     * @return
     */
    RightsSettingDto getItemByRightsSettingId4AppletHome(Long rightsSettingId, Long wechatUserId, String rightsType, Integer readType, Long bookId, Long adviserId, Long channelId);

    /**
     * 每周/长期权益查询--小程序
     * @param rightsSettingId
     * @param rightsType
     * @param wechatUserId
     * @return
     */
    List<RightsSettingItem> getItemsByRightsSettingId4Applet(Long rightsSettingId, String rightsType, Long wechatUserId, Integer readType, Long bookId, Long adviserId, Long channelId);

    /**
     * 查所有权益分类
     * @param rightsType
     * @return
     */
    List<RightsSettingClassify>getAllRightsClassify(String rightsType);

    /**
     * @Author David
     * @Description 该方法没有补充咨询且会查询所有类型的即可权益，不利于扩展，请使用新方法getRightsSettingRightsNowItemsByType
     * @Date 2020/4/25 11:44
     * @Param [rightsSettingId, wechatUserId]
     * @return com.pcloud.book.rightsSetting.entity.RightsSetting
     **/
    @Deprecated
    RightsSetting getRightsSettingRightsNowItems(Long rightsSettingId, Long wechatUserId);

    /**
     * @Author David
     * @Description 根据权益id和类型获取权益内容
     * @Date 2020/4/25 11:44
     * @Param [rightsSettingId, wechatUserId, type]
     * @return com.pcloud.book.rightsSetting.entity.RightsSetting
     **/
    RightsSetting getRightsSettingRightsNowItemsByType(Long rightsSettingId, Long wechatUserId, Integer type, Long adviserId, Long bookId, Long channelId, Integer readType);

    RightsSetting getRightsSettingGiftCoupons(Long rightsSettingId, Long wechatUserId, Integer readType);

    FillRightsSettingAppletsDTO getFillRightsSettingApplets(Long rightsSettingId, Long wechatUserId, Long rightsClassifyId,
            Integer top, Long bookId);

    List<RightsItemGroup> getRightsItemGroups(Long rightsSettingId, Long adviserId, Long bookId, Long channelId, Boolean removeCanNotBuy, Integer readType);

    RightsSettingDto getRightSettingByBookId(Long bookId, Long adviserId, Long channelId);

    List<RightsNowPic> getAllDefaultRightsNowPics(Integer type);

    void addRightsNowPic(RightsNowPic rightsNowPic);

    PageBeanNew<RightsNowPic> getRightsNowPics(Integer currentPage, Integer numPerPage, Integer type);

    void deleteRightsNowPic(Long rightsNowPicId);

    RightsSettingDto getReadType4Book(Long wechatUserId, Long bookId, Long channelId, Long adviserId);

    /**
     * 增加上下册分类权益
     * @author：zhuyajie
     * @date：2020/5/20 19:09
     *  * @param null
     */
    void copyRightsSetting(List<Long> volLabelIds);

    /**
     * 根据书以及阅读方式查询周权益下的咨询
     */
    PageBeanNew<AppletNewsDTO> getWeekRightsSettingNewsByBookId(AppletUserBookcase userReadBook, Integer currentPage, Integer numPerPage);

    /**
     * 书刊权益批量上下架
     * @param rightsSettingShowStateDTO
     */
    void batchUpdateShowState(RightsSettingShowStateDTO rightsSettingShowStateDTO);

    Map<Long, RightsSettingDto> listByBookIds(List<Long> bookIds);
}
