package com.pcloud.common.core.aspect;

import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.string.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

import java.io.*;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;

/**
 * 添加监控，查看
 */
@Component
@Aspect
@Slf4j
public class JedisClusterAspect {
    //需要统计的方法调用次数
    private LongAdder allGetLongAdder = new LongAdder();
    private LongAdder allRpopLongAdder = new LongAdder();
    private LongAdder allHgetAllLongAdder = new LongAdder();

    private LongAdder missGetLongAdder = new LongAdder();
    private LongAdder missRpopLongAdder = new LongAdder();
    private LongAdder missHgetAllLongAdder = new LongAdder();
    private ConcurrentHashMap<String, AtomicInteger> missKeyMap = new ConcurrentHashMap<>();
    private ConcurrentHashMap<String, AtomicInteger> tempMap = new ConcurrentHashMap<>();
    private LongAdder getSetLongAdder = new LongAdder();
    private LongAdder missGetSetLongAdder = new LongAdder();

    private LongAdder getSetRLongAdder = new LongAdder();
    private LongAdder missgetSetRLongAdder = new LongAdder();

    private LongAdder setnxLongAdder = new LongAdder();
    private LongAdder missSetnxLongAdder = new LongAdder();

    private LongAdder hmgetLongAdder = new LongAdder();
    private LongAdder misshmgetLongAdder = new LongAdder();

    private LongAdder hgetLongAdder = new LongAdder();
    private LongAdder misshgetLongAdder = new LongAdder();

    private LongAdder hlenLongAdder = new LongAdder();
    private LongAdder misshlenLongAdder = new LongAdder();

    private LongAdder hkeysLongAdder = new LongAdder();
    private LongAdder misshkeysLongAdder = new LongAdder();

    private LongAdder lpopLongAdder = new LongAdder();
    private LongAdder misslpopLongAdder = new LongAdder();

    private LongAdder zcardLongAdder = new LongAdder();
    private LongAdder misszcardLongAdder = new LongAdder();

    private LongAdder zrevrangeLongAdder = new LongAdder();
    private LongAdder misszrevrangeLongAdder = new LongAdder();

    private LongAdder ttlLongAdder = new LongAdder();
    private LongAdder misshttlLongAdder = new LongAdder();

    private LongAdder zrankLongAdder = new LongAdder();
    private LongAdder misszrankLongAdder = new LongAdder();
    private LongAdder lrangeLongAdder = new LongAdder();
    private LongAdder misslrangeLongAdder = new LongAdder();

    private LongAdder llenLongAdder = new LongAdder();
    private LongAdder missllenLongAdder = new LongAdder();

    public JedisClusterAspect() {
        new PringLogThread().start();
    }

    @Pointcut("execution(* redis.clients.jedis.JedisCluster.*(..))")
    public void pointcut() {

    }

    class PringLogThread extends Thread {
        @Override
        public void run() {
            String path = getResourceBasePath() + File.separator + "redislog" + File.separator;
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            while (true) {
                BufferedWriter out = null;
                try {
                    Thread.sleep(60 * 60 * 1000);
                    tempMap.clear();
                    tempMap.putAll(missKeyMap);
                    missKeyMap.clear();
                    StringBuffer logStr = new StringBuffer("\n");
                    logStr.append("get调用：" + allGetLongAdder.intValue() + "次，未命中：" + missGetLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("rpop调用：" + allRpopLongAdder.intValue() + "次，未命中：" + missRpopLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("hgetall调用：" + allHgetAllLongAdder.intValue() + "次，未命中：" + missHgetAllLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("getSet调用：" + getSetLongAdder.intValue() + "次，未命中：" + missGetSetLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("hget调用：" + hgetLongAdder.intValue() + "次，未命中：" + misshgetLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("hlen调用：" + hlenLongAdder.intValue() + "次，未命中：" + misshlenLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("lrange调用：" + lrangeLongAdder.intValue() + "次，未命中：" + misslrangeLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("llen调用：" + llenLongAdder.intValue() + "次，未命中：" + missllenLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("hkeys调用：" + hkeysLongAdder.intValue() + "次，未命中：" + misshkeysLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("lpop调用：" + lpopLongAdder.intValue() + "次，未命中：" + misslpopLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("zcard调用：" + zcardLongAdder.intValue() + "次，未命中：" + misszcardLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("zrevrange调用：" + zrevrangeLongAdder.intValue() + "次，未命中：" + misszrevrangeLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("ttl调用：" + ttlLongAdder.intValue() + "次，未命中：" + misshttlLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("zrank调用：" + zrankLongAdder.intValue() + "次，未命中：" + misszrankLongAdder.intValue() + "次");
                    logStr.append("getSetR调用：" + getSetRLongAdder.intValue() + "次，未命中：" + missgetSetRLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("setnx调用：" + setnxLongAdder.intValue() + "次，未命中：" + missSetnxLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("hmget调用：" + hmgetLongAdder.intValue() + "次，未命中：" + misshmgetLongAdder.intValue() + "次");
                    logStr.append("\n");
                    logStr.append("\n");
                    String fileName = "redisOperate" + DateUtils.getYmdHmsTime() + ".log";
                    out = new BufferedWriter(new FileWriter(path + fileName));
                    out.write(logStr.toString());
                    out.newLine();
                    for (Map.Entry<String, AtomicInteger> entry : tempMap.entrySet()) {
                        out.write(entry.getKey() + "未命中：" + entry.getValue().intValue());
                        out.newLine();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    try {
                        out.close();
                    } catch (IOException e) {
                    }
                }
            }
        }
    }

    @AfterReturning(value = "pointcut()", returning = "result")
    public void afterReturning(JoinPoint joinPoint, Object result) {
        String methodName = joinPoint.getSignature().getName();
        Object[] obj = joinPoint.getArgs();
        String key = obj[0].toString();
        switch (methodName) {
            case "get":
                allGetLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    missGetLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "rpop":
                allRpopLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    missRpopLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "hgetAll":
                allHgetAllLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    missHgetAllLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "getSet":
                getSetLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    missGetSetLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "getSetR":
                getSetRLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    missgetSetRLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "setnx":
                setnxLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    missSetnxLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "hmget":
                hmgetLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    misshmgetLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "hget":
                hgetLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    misshgetLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "hlen":
                hlenLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    misshlenLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "lrange":
                lrangeLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    misslrangeLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "llen":
                llenLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    missllenLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "hkeys":
                hkeysLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    misshkeysLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "lpop":
                lpopLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    misslpopLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "zcard":
                zcardLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    misszcardLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "zrevrange":
                zrevrangeLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    misszrevrangeLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "ttl":
                ttlLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    misshttlLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            case "zrank":
                zrankLongAdder.add(1);
                if (result == null || StringUtil.isEmpty(result.toString())) {
                    misszrankLongAdder.add(1);
                    addMissCount(missKeyMap, key);
                }
                break;
            default:

        }
    }

    private static String getResourceBasePath() {
        // 获取跟目录
        File path = null;
        try {
            path = new File(ResourceUtils.getURL("classpath:").getPath());
        } catch (FileNotFoundException e) {
            // nothing to do
        }
        if (path == null || !path.exists()) {
            path = new File("");
        }

        String pathStr = path.getAbsolutePath();
        // 如果是在eclipse中运行，则和target同级目录,如果是jar部署到服务器，则默认和jar包同级
        pathStr = pathStr.replace("\\target\\classes", "");

        return pathStr;
    }

    public void addMissCount(ConcurrentHashMap<String, AtomicInteger> map, String key) {
        AtomicInteger missCount = map.get(key);
        if (missCount == null) {
            missCount = new AtomicInteger(1);
        } else {
            missCount.getAndIncrement();
        }
        map.put(key, missCount);
    }

}
