package com.pcloud.common.core.datasource;

import java.sql.SQLException;
import java.util.ArrayList;

import javax.sql.DataSource;

import com.alibaba.druid.support.http.StatViewServlet;
import com.pcloud.common.core.mybatis.interceptor.ExecutorInterceptor;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import com.alibaba.druid.pool.DruidDataSource;

@Configuration
@ConfigurationProperties(prefix = "spring.datasource")
@MapperScan(basePackages = DataSourceConfig.PACKAGE, sqlSessionFactoryRef = "sqlSessionFactory")
public class DataSourceConfig {
	private Logger logger = LoggerFactory.getLogger(DataSourceConfig.class);

	static final String PACKAGE = "com.pcloud.common.core.dao";

	private String url;

	private String type;

	private String username;

	private String password;

	private String driverClassName;

	private int initialSize;

	private int minIdle;

	private int maxActive;

	private int maxWait;

	private int timeBetweenEvictionRunsMillis;

	private int minEvictableIdleTimeMillis;

	private String validationQuery;

	private boolean testWhileIdle;

	private boolean testOnBorrow;

	private boolean testOnReturn;

	private boolean poolPreparedStatements;

	private String filtersNew;

	private String connectionPropertiesNew;

	@Value("${mybatis.mapper-locations}")
	private String mapperLocations;

	@Value("${mybatis.type-aliases-package}")
	private String typeAliasesPackage;

	// @Value("${spring.datasource.useGlobalDataSourceStat}")
	// private boolean useGlobalDataSourceStat;
	//
	// @Value("${spring.datasource.druidLoginName}")
	// private String druidLoginName;
	//
	// @Value("${spring.datasource.druidPassword}")
	// private String druidPassword;

	@Bean(name = "druidDataSource")
	@Primary // 不要漏了这
	public DataSource dataSource() {
		DruidDataSource datasource = new DruidDataSource();
		try {
			datasource.setUrl(url);
			datasource.setDbType(type);
			datasource.setUsername(username);
			datasource.setPassword(password);
			datasource.setDriverClassName(driverClassName);
			datasource.setInitialSize(initialSize);
			datasource.setMinIdle(minIdle);
			datasource.setMaxActive(maxActive);
			datasource.setMaxWait(maxWait);
			datasource.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
			datasource.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
			datasource.setValidationQuery(validationQuery);
			datasource.setTestWhileIdle(testWhileIdle);
			datasource.setTestOnBorrow(testOnBorrow);
			datasource.setTestOnReturn(testOnReturn);
			datasource.setPoolPreparedStatements(poolPreparedStatements);
			datasource.setFilters(filtersNew);
			datasource.setConnectionProperties(connectionPropertiesNew);
			// datasource.setUseGlobalDataSourceStat(useGlobalDataSourceStat);
			ArrayList<String> arr = new ArrayList<>();
			arr.add("set names utf8mb4;");
			datasource.setConnectionInitSqls(arr);
		} catch (SQLException e) {
			logger.error("druid configuration initialization filter", e);
		}
		return datasource;
	}

	@Bean
	public ServletRegistrationBean druidStatViewServlet(){
		//org.springframework.boot.context.embedded.ServletRegistrationBean提供类的进行注册.
		ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean(new StatViewServlet(),"/druid/*");
		//登录查看信息的账号密码.
		servletRegistrationBean.addInitParameter("loginUsername","admin");
		servletRegistrationBean.addInitParameter("loginPassword","Rays123456");
		//是否能够重置数据.
		servletRegistrationBean.addInitParameter("resetEnable","true");
		return servletRegistrationBean;
	}

	@Bean(name = "transactionManager")
	public DataSourceTransactionManager transactionManager() {
		logger.info("【DataSource】初始化TransactionManager事务管理器，<START>");
		return new DataSourceTransactionManager(dataSource());
	}

	@Bean(name = "sqlSessionFactory")
	@Autowired
	public SqlSessionFactory sqlSessionFactory(ExecutorInterceptor interceptor) throws Exception {
		logger.info("【DataSource】初始化SqlSessionFactory，<START>");
		final SqlSessionFactoryBean sessionFactoryBean = new SqlSessionFactoryBean();
		sessionFactoryBean.setDataSource(dataSource());
		sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(mapperLocations));
		sessionFactoryBean.setVfs(SpringBootVFS.class);
		sessionFactoryBean.setTypeAliasesPackage(typeAliasesPackage);
		sessionFactoryBean.setPlugins(new Interceptor[] { interceptor });
		return sessionFactoryBean.getObject();
	}

	@Bean(name = "sqlSessionTemplate")
	@Autowired
	public SqlSessionTemplate sqlSessionTemplate(ExecutorInterceptor interceptor) throws Exception {
		logger.info("【DataSource】初始化SqlSessionTemplate，<START>");
		final SqlSessionTemplate sessionFactoryBean = new SqlSessionTemplate(sqlSessionFactory(interceptor));
		return sessionFactoryBean;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getDriverClassName() {
		return driverClassName;
	}

	public void setDriverClassName(String driverClassName) {
		this.driverClassName = driverClassName;
	}

	public int getInitialSize() {
		return initialSize;
	}

	public void setInitialSize(int initialSize) {
		this.initialSize = initialSize;
	}

	public int getMinIdle() {
		return minIdle;
	}

	public void setMinIdle(int minIdle) {
		this.minIdle = minIdle;
	}

	public int getMaxActive() {
		return maxActive;
	}

	public void setMaxActive(int maxActive) {
		this.maxActive = maxActive;
	}

	public int getMaxWait() {
		return maxWait;
	}

	public void setMaxWait(int maxWait) {
		this.maxWait = maxWait;
	}

	public int getTimeBetweenEvictionRunsMillis() {
		return timeBetweenEvictionRunsMillis;
	}

	public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
		this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
	}

	public int getMinEvictableIdleTimeMillis() {
		return minEvictableIdleTimeMillis;
	}

	public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
		this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
	}

	public String getValidationQuery() {
		return validationQuery;
	}

	public void setValidationQuery(String validationQuery) {
		this.validationQuery = validationQuery;
	}

	public boolean isTestWhileIdle() {
		return testWhileIdle;
	}

	public void setTestWhileIdle(boolean testWhileIdle) {
		this.testWhileIdle = testWhileIdle;
	}

	public boolean isTestOnBorrow() {
		return testOnBorrow;
	}

	public void setTestOnBorrow(boolean testOnBorrow) {
		this.testOnBorrow = testOnBorrow;
	}

	public boolean isTestOnReturn() {
		return testOnReturn;
	}

	public void setTestOnReturn(boolean testOnReturn) {
		this.testOnReturn = testOnReturn;
	}

	public boolean isPoolPreparedStatements() {
		return poolPreparedStatements;
	}

	public void setPoolPreparedStatements(boolean poolPreparedStatements) {
		this.poolPreparedStatements = poolPreparedStatements;
	}

	public String getFiltersNew() {
		return filtersNew;
	}

	public void setFiltersNew(String filtersNew) {
		this.filtersNew = filtersNew;
	}

	public String getConnectionPropertiesNew() {
		return connectionPropertiesNew;
	}

	public void setConnectionPropertiesNew(String connectionPropertiesNew) {
		this.connectionPropertiesNew = connectionPropertiesNew;
	}

	public String getMapperLocations() {
		return mapperLocations;
	}

	public void setMapperLocations(String mapperLocations) {
		this.mapperLocations = mapperLocations;
	}

	public String getTypeAliasesPackage() {
		return typeAliasesPackage;
	}

	public void setTypeAliasesPackage(String typeAliasesPackage) {
		this.typeAliasesPackage = typeAliasesPackage;
	}

}
