package com.pcloud.common.utils.mq;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

import com.pcloud.common.utils.UUIDUitl;

/**
 * 
 * @描述：MQ消息
 * @作者：shichunshan
 * @创建时间：2016年6月23日,下午2:31:42
 * @版本：1.0
 */
public class MqMessage implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 消息id
	 */
	private String id;
	/**
	 * 类型
	 */
	private MqMessageTypeEnum messageType;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 消息内容
	 */
	private String content;
	
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public MqMessageTypeEnum getNotifyType() {
		return messageType;
	}

	public void setNotifyType(MqMessageTypeEnum messageType) {
		this.messageType = messageType;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public MqMessage() {
		super();
		this.id=UUIDUitl.generateString(40);
		this.createDate=new Date();
	}

	/**
	 * @param notifyType 消息类型
	 * @param content 消息内容
	 */
	public MqMessage(MqMessageTypeEnum notifyType, String content) {
		this();
		this.messageType = notifyType;
		this.content = content;
	}

	@Override
	public String toString() {
		return "MqMessage [id=" + id + ", messageType=" + messageType + ", createDate=" + createDate + ", content="
				+ content + "]";
	}
	
}
