package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.entity.AdvertisingBmOption;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @描述：报名选项
 * @作者：zhuyajie
 * @创建时间：20:05 2019/6/27
 * @版本：1.0
 */
public interface BmOptionDao extends BaseDao<AdvertisingBmOption> {

    /**
     * 获取报名列表
     * @param cpaId
     * @return
     */
    List<AdvertisingBmOption> getByCPAId(Long cpaId);

    /**
     * 批量删除
     * @param optionIds
     */
    void deleteByIds(List<Long> optionIds);

    /**
     * 根据cpaid获取选项id列表
     * @param cpaId
     * @return
     */
    List<Long> getOptionIdsByCPAId(Long cpaId);

    /**
     * 查手机号选项id
     * @param adId
     * @return
     */
    Long getMobilePhoneOptionIdByCPA(Long adId);
    /**
     * 更新cpaId
     * @param adId
     * @param cpaId
     */
    void updateCPAId(Long adId, Long cpaId);
}
