package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.BmOptionDao;
import com.pcloud.book.advertising.entity.AdvertisingBmOption;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：报名选项
 * @作者：zhuyajie
 * @创建时间：20:14 2019/6/27
 * @版本：1.0
 */
@Component("bmOptionDao")
public class BmOptionDaoImpl extends BaseDaoImpl<AdvertisingBmOption> implements BmOptionDao {
    @Override
    public List<AdvertisingBmOption> getByCPAId(Long cpaId) {
        return getSessionTemplate().selectList(getStatement("getByCPAId"), cpaId);
    }

    @Override
    public void deleteByIds(List<Long> optionIds) {
        getSessionTemplate().delete(getStatement("deleteByIds"), optionIds);
    }

    @Override
    public List<Long> getOptionIdsByCPAId(Long cpaId) {
        return getSessionTemplate().selectList(getStatement("getOptionIdsByCPAId"), cpaId);
    }

    @Override
    public Long getMobilePhoneOptionIdByCPA(Long cpaId) {
        return getSessionTemplate().selectOne(getStatement("getMobilePhoneOptionIdByCPA"),cpaId);
    }

    @Override
    public void updateCPAId(Long adId, Long cpaId) {
        Map<String, Object> map = new HashMap<>();
        map.put("adId", adId);
        map.put("cpaId", cpaId);
        getSessionTemplate().update(getStatement("updateCPAId"), map);
    }
}
