package com.pcloud.book.advertising.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.io.Serializable;

/**
 * 品牌方数据修改(AdvertisingBrandData)实体类
 *
 * @author zhuyajie
 * @since 2020-04-16 11:39:22
 */
public class AdvertisingBrandData extends BaseEntity {
    private static final long serialVersionUID = -93346942764371273L;
    
    private Long id;
    /**
    * 来源类型（BOOK/QRCODE/APP/PRODUCT）
    */
    private String fromType;
    /**
    * 书刊id
    */
    private Long bookId;
    /**
    * 编辑id
    */
    private Long adviserId;
    /**
    * 运营id
    */
    private Long channelId;
    /**
    * 二维码id
    */
    private Long sceneId;
    /**
    * 应用或作品id
    */
    private Long serveId;
    /**
    * 修改的数据类型
    */
    private String addType;
    /**
    * 增加数量
    */
    private Integer addCount;
    /**
    * 创建时间
    */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
    * 修改时间
    */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFromType() {
        return fromType;
    }

    public void setFromType(String fromType) {
        this.fromType = fromType;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public Long getServeId() {
        return serveId;
    }

    public void setServeId(Long serveId) {
        this.serveId = serveId;
    }

    public String getAddType() {
        return addType;
    }

    public void setAddType(String addType) {
        this.addType = addType;
    }

    public Integer getAddCount() {
        return addCount;
    }

    public void setAddCount(Integer addCount) {
        this.addCount = addCount;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

}