package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AddBookParamDTO;
import com.pcloud.book.applet.dto.AppletBooklistClassifyDTO;
import com.pcloud.book.applet.dto.AppletBooklistDTO;
import com.pcloud.book.applet.dto.BookDTO4Booklist;
import com.pcloud.book.applet.entity.AppletBooklist;
import com.pcloud.book.applet.entity.AppletBooklistClassify;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

/**
 * 小程序书单
 */
public interface AppletBooklistBiz {

    /**
     * 新增书单栏目
     * @param appletBooklistClassify
     */
    Long addBooklistClassify(AppletBooklistClassify appletBooklistClassify);

    /**
     * 删除书单栏目
     * @param id
     */
    void deleteBooklistClassifyById(Long id);

    /**
     * 修改书单栏目
     * @param appletBooklistClassify
     */
    void updateBooklistClassify(AppletBooklistClassify appletBooklistClassify);

    /**
     * 书单栏目列表
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletBooklistClassifyDTO> listBooklistClassify(Integer currentPage, Integer numPerPage, String name);

    /**
     * 新增书单
     * @param appletBooklist
     * @return
     */
    Long addBooklist(AppletBooklist appletBooklist);

    /**
     * 删除书单
     * @param id
     */
    void deleteBooklistById(Long id);

    /**
     * 修改书单
     * @param appletBooklist
     */
    void updateBooklist(AppletBooklist appletBooklist);

    /**
     * 根据id查书单
     */
    AppletBooklistDTO getBooklistById(Long id);

    /**
     * 书单管理列表
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletBooklistDTO> listBooklist(Integer currentPage, Integer numPerPage, String name, Long classifyId);

    /**
     * 书单添加图书
     * @param addBookParamDTO
     */
    void addBookToBooklist(AddBookParamDTO addBookParamDTO);

    /**
     *获取书单下书籍列表
     * @param booklistId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<BookDTO4Booklist> listPageBook4AppletBooklist(Long booklistId, Integer currentPage, Integer numPerPage);
    /**
     * 更新书籍排序
     * @param configId
     * @param seq
     */
    void updateBookSeq(Long configId, Integer seq);

    /**
     * 获取所有书单栏目
     * @return
     */
    List<AppletBooklistClassifyDTO> getAllBooklistClassify(Boolean showState);

    /**
     * 客户端获取书单列表
     * @param classifyId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletBooklistDTO> listBooklist4Wechat(Long classifyId, Integer currentPage, Integer numPerPage, Long wechatUserId);

    /**
     * 客户端根据id获取书单
     * @param booklistId
     * @return
     */
    AppletBooklistDTO getBooklistById4Wechat(Long booklistId);

    /**
     * 图书详情-出版作者分类书名
     * @param adviserId
     * @param channelId
     * @param bookId
     * @return
     */
    BookDTO4Booklist getByBookIdAdviserChannel(Long adviserId, Long channelId, Long bookId);

    /**
     * 用户选择书单栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:21
     *  * @param null
     */
    void addUserBooklistClassify(List<Long> classifyIds, Long wechatUserId);
    /**
     * 所有书单栏目列表+用户选择的书单栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:21
     *  * @param null
     */
    List<AppletBooklistClassifyDTO> getAllBooklistClassify4Wechat(Long wechatUserId);
    /**
     * 用户选择的书单栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:21
     *  * @param null
     */
    List<AppletBooklistClassifyDTO> getBooklistClassifyByUser(Long wechatUserId);
}
