package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletNewsDao;
import com.pcloud.book.applet.dto.AppletNewsCustomTagDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.book.applet.entity.AppletNewsCustomTag;
import com.pcloud.book.applet.vo.AppletNewsClassifyVO;
import com.pcloud.book.applet.vo.AppletNewsShowStateVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 小程序资讯
 */
@Component
public class AppletNewsDaoImpl extends BaseDaoImpl<AppletNews> implements AppletNewsDao {

    @Override
    public List<AppletNews> getByNewsClassifyId(Long newsClassifyId) {
        return getSessionTemplate().selectList(getStatement("getByNewsClassifyId"), newsClassifyId);
    }

    @Override
    public void updateNewsShowState(AppletNews appletNews) {
        getSessionTemplate().update(getStatement("updateNewsShowState"),appletNews);
    }

    @Override
    public List<AppletNewsDTO> getByNewsByTempletLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, String rightsType) {
        Map<String,Object> map = new HashMap<>();
        map.put("firstClassify", firstClassify);
        map.put("secondClassify", secondClassify);
        map.put("gradeLabelId",gradeLabelId);
        map.put("subjectLabelId", subjectLabelId);
        map.put("rightsType",rightsType);
        return getSessionTemplate().selectList(getStatement("getByNewsByTempletLabel"),map);

    }

    @Override
    public List<AppletNews> getByTempletAndClassify(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long rightsClassifyId, Integer top) {
        Map<String,Object> map = new HashMap<>();
        map.put("firstClassify", firstClassify);
        map.put("secondClassify", secondClassify);
        map.put("gradeLabelId",gradeLabelId);
        map.put("subjectLabelId", subjectLabelId);
        map.put("rightsClassifyId",rightsClassifyId);
        map.put("top", top);
        return getSessionTemplate().selectList(getStatement("getByTempletAndClassify"),map);
    }

    @Override
    public void insertSource(String source) {
        getSessionTemplate().insert(getStatement("insertSource"),source);
    }

    @Override
    public List<String> getNewsSourceList() {
        return getSessionTemplate().selectList(getStatement("getNewsSourceList"));
    }

    @Override
    public Integer getAppletNewsSourceCount(String source) {
        return getSessionTemplate().selectOne(getStatement("getAppletNewsSourceCount"),source);
    }

    @Override
    public void deleteSource(String source) {
        getSessionTemplate().delete(getStatement("deleteSource"),source);
    }

    @Override
    public Boolean newsSourceExist(String source) {
        return getSessionTemplate().selectOne(getStatement("newsSourceExist"),source);
    }

    @Override
    public void batchUpdateClassify(AppletNewsClassifyVO appletNewsClassifyVO) {
        Map<String,Object> map = new HashMap<>();
        map.put("ids", appletNewsClassifyVO.getAppletNewsIds());
        map.put("firstClassify", appletNewsClassifyVO.getFirstClassify());
        map.put("secondClassify", appletNewsClassifyVO.getSecondClassify());
        map.put("gradeLabelId", appletNewsClassifyVO.getGradeLabelId());
        map.put("subjectLabelId", appletNewsClassifyVO.getSubjectLabelId());
        map.put("rightsClassifyId", appletNewsClassifyVO.getRightsClassifyId());
        map.put("newsClassifyId", appletNewsClassifyVO.getNewsClassifyId());
        getSessionTemplate().update(getStatement("batchUpdateClassify"), map);
    }

    @Override
    public void batchUpdateShowState(AppletNewsShowStateVO appletNewsShowStateVO) {
        Map<String,Object> map = new HashMap<>();
        map.put("ids", appletNewsShowStateVO.getAppletNewsIds());
        map.put("showState", appletNewsShowStateVO.getShowState());
        getSessionTemplate().update(getStatement("batchUpdateShowState"), map);
    }

    @Override
    public void batchDeleteAppletNews(List<Long> list) {
        getSessionTemplate().delete(getStatement("batchDeleteAppletNews"), list);
    }

    @Override
    public String getUrlNumberByJumpUrl(String jumpUrl) {
        return getSessionTemplate().selectOne(getStatement("getUrlNumberByJumpUrl"), jumpUrl);
    }

    @Override
    public Boolean urlNumberExist(String urlNumber, Long id) {
        Map<String, Object> map = new HashMap<>();
        map.put("urlNumber", urlNumber);
        map.put("id", id);
        return getSessionTemplate().selectOne(getStatement("urlNumberExist"), map);
    }

    @Override
    public Map<Long, AppletNewsDTO> getByIds(List<Long> list) {
        return this.getSqlSession().selectMap(getStatement("getByIds"), list, "id");
    }

    @Override
    public void batchUpdateNewsClassify(AppletNewsClassifyVO appletNewsClassifyVO) {
        Map<String,Object> map = new HashMap<>();
        map.put("ids", appletNewsClassifyVO.getAppletNewsIds());
        map.put("newsClassifyId", appletNewsClassifyVO.getNewsClassifyId());
        getSessionTemplate().update(getStatement("batchUpdateNewsClassify"), map);
    }

    @Override
    public void batchUpdateCustomTagId(List<Long> ids, Long customTagId) {
        Map<String, Object> map = new HashMap<>();
        map.put("ids", ids);
        map.put("customTagId", customTagId);
        getSessionTemplate().update(getStatement("batchUpdateCustomTagId"), map);
    }

    @Override
    public void insertCustomTag(AppletNewsCustomTag appletNewsCustomTag) {
        getSessionTemplate().insert(getStatement("insertCustomTag"), appletNewsCustomTag);
    }

    @Override
    public void updateCustomTag(AppletNewsCustomTag appletNewsCustomTag) {
        getSessionTemplate().update(getStatement("updateCustomTag"), appletNewsCustomTag);
    }

    @Override
    public List<AppletNewsCustomTagDTO> getCustomTagList() {
        return getSessionTemplate().selectList(getStatement("getCustomTagList"));
    }

    @Override
    public Boolean customTagExist(String customTag) {
        return getSessionTemplate().selectOne(getStatement("customTagExist"), customTag);
    }

    @Override
    public List<Long> getNewsIdListByCustomTagId(Long customTagId) {
        return getSessionTemplate().selectList(getStatement("getNewsIdListByCustomTagId"), customTagId);
    }

}
