package com.pcloud.book.giftcoupon.dto;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

import lombok.Data;

@Data
public class MyGiftPackageDTO {

    /**
     * 券id
     */
    private Long id;
    /**
     * 封面图
     */
    private String coverPic;
    /**
     * 名称
     */
    private String title;
    /**
     * 有效期开始时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date validDateBegin;
    /**
     * 有效期结束时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date validDateEnd;
    /**
     * 面额
     */
    private Integer denomination;

    /**
     * 未使用数量
     */
    private Integer notUsedNum;

    /**
     * 券类型（2-书币券，1-课程券）
     */
    private Integer couponType;
    /**
     * 使用说明
     */
    private String instructions;

    /**
     * 课程券使用方式（1-链接兑取，2-复制码）
     */
    private Integer useType;
    /**
     * 兑换地址
     */
    private String exchangeAddress;


    /**
     * 使用时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm",
            timezone = "GMT+8"
    )
    private Date useTime;

    /**
     * 领取id
     */
    private Long receiveId;

    /**
     * 失效状态 (1-已使用，2-已过期)
     */
    private Integer failureState;


}
