package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.BookClassifyDTO;
import com.pcloud.book.group.dto.BookGroupStatisticDTO;
import com.pcloud.book.group.dto.ClassifyDTO;
import com.pcloud.book.group.dto.ClassifyKeywordDTO;
import com.pcloud.book.group.dto.ClickClassifyDTO;
import com.pcloud.book.group.dto.GroupClassifyQrcodeDTO;
import com.pcloud.book.group.dto.GroupNameAndMaxSeqDTO;
import com.pcloud.book.group.dto.GroupQrcode4ClassifyDTO;
import com.pcloud.book.group.dto.GroupQrcodeBaseDTO;
import com.pcloud.book.group.dto.ProAssocGroupAndUserNumberDTO;
import com.pcloud.book.group.dto.SelfBookGroupStDTO;
import com.pcloud.book.group.entity.BookGroupClassify;
import com.pcloud.book.group.vo.BookGroupQrcodeStatisticVO;
import com.pcloud.book.group.vo.ClassifyNameVO;
import com.pcloud.book.group.vo.ClassifyVO;
import com.pcloud.book.group.vo.GroupQrcode4ClassifyVO;
import com.pcloud.book.group.vo.ListClassify4WechatVO;
import com.pcloud.book.group.vo.ListClassifyVO;
import com.pcloud.book.group.vo.StatisticVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/17 11:20
 */
public interface BookGroupClassifyDao extends BaseDao<BookGroupClassify> {
    /**
     * @Author:lili
     * @Desr:获取是否有该分类
     * @Date:2019/4/17 17:57
     */
    Boolean isHaveThisClassify(String classify, Long classifyId, Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取分类
     * @Date:2019/4/18 10:19
     */
    ClassifyVO getClassify(Long classifyId);

    /**
     * @Author:lili
     * @Desr:获取分类
     * @Date:2019/4/18 10:19
     */
    ClassifyDTO getById(Long classifyId);

    /**
     * @Author:lili
     * @Desr:更新规格标识
     * @Date:2019/4/18 11:32
     */
    void updateSpecId(Long id, Long productSpecId);

    /**
     * @Author:lili
     * @Desr:删除分类
     * @Date:2019/4/18 11:48
     */
    void deleteClassify(Long classifyId, Long partyId);

    /**
     * @Author:lili
     * @Desr:、获取分类个数
     * @Date:2019/4/18 16:28
     */
    Integer getClassifyCount(Long bookGroupId);

    /**
     * 据id获取微信分类
     * @param weixinGroupClassifyPrimaryIds
     * @return
     */
    List<BookGroupClassify> getClassifyByIds(List<Long> weixinGroupClassifyPrimaryIds);


    /**
     * @Author:lili
     * @Desr:获取所有分类列表
     * @Date:2019/4/18 19:46
     */
    List<ListClassifyVO> listAllClassifyByRank(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:根据规格获取分类基本信息
     * @Date:2019/4/19 11:48
     */
    ClassifyDTO getBaseInfoBySpecId(Long productSpecId);

    /**
     * @Author:lili
     * @Desr:获取分类列表（排序方式是群总人数）
     * @Date:2019/4/19 15:13
     */
    List<ListClassifyVO> listAllClassifyByUser(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:更排序分类值
     * @Date:2019/4/22 15:55
     */
    void updateClassifyRank(BookGroupClassify bookGroupClassify);

    /**
     * @Author:lili
     * @Desr:获取所有分类名称（排序值）
     * @Date:2019/4/22 16:03
     */
    List<ClassifyNameVO> listClassifyByRank(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取所有分类名称（总人数）
     * @Date:2019/4/22 16:03
     */
    List<ClassifyNameVO> listClassifyByUser(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取群数量
     * @Date:2019/4/26 14:58
     */
    Integer getGroupCount(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取总用户数
     * @Date:2019/4/26 15:02
     */
    Integer getUserNumberCount(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取分类社群码名称以及最大群数量
     * @Date:2019/4/28 17:26
     */
    GroupNameAndMaxSeqDTO getGroupNameAndMaxSeq(Long classifyId);

    /**
     * @Author:lili
     * @Desr:获取分类二维码相关标识
     * @Date:2019/4/28 20:32
     */
    GroupClassifyQrcodeDTO getClassifyQrcodeInfo(String weixinGroupId);

    /**
     * 批量获取分类信息
     */
    List<GroupClassifyQrcodeDTO> listClassifyQrcodeInfo(List<Long> classifyIds);

    /**
     * @Author:lili
     * @Desr:获取所有的分类
     * @Date:2019/4/29 11:23
     */
    List<ListClassify4WechatVO> listClassify4Wechat(Long bookGroupId, Integer rankType);

    /**
     * @Author:lili
     * @Desr:客户端获取分类使用二维码
     * @Date:2019/4/30 10:06
     */
    GroupQrcode4ClassifyVO getClassifyQrcode(Long classifyId, Integer changeNumber);

    /**
     * @Author:lili
     * @Desr:获取社群码统计数据（分类数，群总人数，群数量）
     * @Date:2019/4/30 17:48
     */
    Map<Long,BookGroupStatisticDTO> getBookGroupStatistic(List<Long> bookGroupIds);

    /**
     * @Author:lili
     * @Desr:获取单个群统计数据
     * @Date:2019/5/6 17:28
     */
    List<BookGroupQrcodeStatisticVO> listBookGroupQrcodeStatistic(List<Long> classifyIds, Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:
     * @Date:2019/5/9 11:25
     */
    StatisticVO getStatistic4Adviser(Long adviserId);

    /**
     * @Author:lili
     * @Desr:获取群二维码基本信息
     * @Date:2019/5/10 14:51
     */
    Map<String,GroupQrcodeBaseDTO> listGroupQrcodeBaseInfo(List<String> weixinGroupIds);

    /**
     * @Author:lili
     * @Desr:获取商品关联群数量与人数
     * @Date:2019/5/10 20:39
     */
    ProAssocGroupAndUserNumberDTO getProAssocGroupAndUserNumber(Long productId);

    /**
     * @Author:lili
     * @Desr:获取最大的排序值
     * @Date:2019/5/14 15:52
     */
    Integer getMaxRank(Long bookGroupId);

    /**
     * 获取分类名称及对应社群码名称
     * @param classifyIds
     * @return
     */
    List<ClassifyDTO> getNameWithBookNameByIds(List<Long> classifyIds);

    /**
     * 获取书下面分类ID集合
     * @param bookGroupIdList
     * @return
     */
    List<Long> getIdByBookGroupIds(List<Long> bookGroupIdList);

    /**
     * 获取书下面分类ID集合
     * @param bookGroupIdList
     * @return
     */
    Map<Long,List<Long>> getClassifyIdsByBookGroupIds(List<Long> bookGroupIdList);

    /**
     * 获取分类名称及对应社群码名称
     * @param paramMap
     * @return
     */
    List<ClassifyDTO> getNameWithBookClockInfoIdByIds(Map<String,Object> paramMap);

    /**
     * 根据bookId获取社群书分类等统计
     * @param bookId
     * @return
     */
    StatisticVO getBookGroupStatistics(Long bookId);

    /**
     * 根据bookId获取社群书分类集合等统计
     * @param bookId
     * @return
     */
    List<ClassifyKeywordDTO> getClassifyStatistics(Long bookId);
	
	Map<Long,BookClassifyDTO> getGroupClassifyCount(List<Long> bookIds);

    GroupClassifyQrcodeDTO getClassifyQrcodeInfoByName(String weixinGroupName);

    /**
     * 更新是否开启学习报告
     */
    void updateHasOpenLearningReport(Long classifyId, Boolean hasOpenLearningReport, Long partyId);


    /**
     * 拖动排序
     */
    void dragSortClassify(List<Long> classifyIds);

    void addClickClassify(Long wechatUserId, Long bookGroupId, Long classifyId);

    Map<Long, ClickClassifyDTO> mapClickClassify(List<Long> classifyIds);

    List<ListClassifyVO> getClassifyIngoreDelete(Long bookGroupId);

    public List<BookGroupClassify> getListByBookGroupId(Long bookGroupId);

    /**
     * 根据类型获取分类数量
     */
    Integer getClassifyCountByJoinGroupType(Integer joinGroupType);

    List<SelfBookGroupStDTO> listClassifyCountInfo(List<Long> bookGroupIds);

    /**
     * 获取群分类数量等信息
     */
    Map<Long,BookGroupStatisticDTO> getClassifyCountAbout(List<Long> bookGroupIds);

    /**
     *获取群分类下面所有可用的二维码
     */
    List<GroupQrcode4ClassifyDTO> getQrcodeByClassifyId4Heals(Long classifyId, Integer changeNumber);
}
