package com.pcloud.book.group.facade;

import com.pcloud.book.group.vo.QrStatisticsVO;
import com.pcloud.book.group.vo.WeixinQrcodeVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.util.List;

/**
 * @author lily
 * @date 2019/4/26 15:10
 */
@Api(description = "微信群二维码")
public interface WeixinQrcodeFacade {

    @ApiOperation(value = "新增群二维码", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "weixinQrcodeVO", value = "二维码dto", dataType = "WeixinQrcodeVO", paramType = "body")
    })
    @PostMapping("addQrcode")
    ResponseDto<?> addQrcode(@RequestBody WeixinQrcodeVO weixinQrcodeVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "平台端获取二维码统计数据", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header")
    })
    @GetMapping("getQrStatistics")
    ResponseDto<QrStatisticsVO> getQrStatistics(@RequestHeader("token") String token)
            throws BizException, PermissionException;

    @GetMapping("getQrStatisticsByVersion")
    ResponseDto<List<QrStatisticsVO>> getQrStatisticsByVersion(@RequestHeader("token") String token)
            throws BizException, PermissionException;


}
