package com.pcloud.book.push.dao.impl;

import com.pcloud.book.push.dao.PushItemDao;
import com.pcloud.book.push.entity.PushItem;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:36
 **/
@Repository("pushItemDao")
public class PushItemDaoImpl extends BaseDaoImpl<PushItem> implements PushItemDao {
    @Override
    public Integer batchInsert(List<PushItem> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void deleteByPushId(Long pushId, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushId",pushId);
        map.put("partyId",partyId);
        super.getSqlSession().update(getStatement("deleteByPushId"), map);
    }

    @Override
    public void deleteByPushItemId(Long pushItemId, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushItemId",pushItemId);
        map.put("partyId",partyId);
        super.getSqlSession().update(getStatement("deleteByPushItemId"), map);
    }

    @Override
    public Integer getMaxSeqNumByPushId(Long pushId) {
        return super.getSqlSession().selectOne(getStatement("getMaxSeqNumByPushId"), pushId);
    }

    @Override
    public void sortPushItems(List<Long> pushItemIds, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushItemIds",pushItemIds);
        map.put("partyId",partyId);
        super.getSqlSession().update(getStatement("sortPushItems"), map);
    }

    @Override
    public List<PushItem> getListByPushIds(List<Long> pushIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushIds",pushIds);
        return super.getSqlSession().selectList(getStatement("getListByPushIds"), map);
    }

    @Override
    public Integer getCountByPushId(Long pushId) {
        return super.getSqlSession().selectOne(getStatement("getCountByPushId"), pushId);
    }

    @Override
    public List<PushItem> getListByPushId(Long pushId) {
        return super.getSqlSession().selectList(getStatement("getListByPushId"), pushId);
    }

    @Override
    public List<PushItem> getAllListByPushIds(List<Long> pushIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushIds",pushIds);
        return super.getSqlSession().selectList(getStatement("getAllListByPushIds"), map);
    }

    @Override
    public void deleteByIds(List<Long> ids, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("ids",ids);
        map.put("partyId",partyId);
        super.getSqlSession().update(getStatement("deleteByIds"), map);
    }
}
