package com.pcloud.book.record.dao.impl;

import com.pcloud.book.record.dao.BookBrowseRecordDAO;
import com.pcloud.book.record.entity.AreaStatistics;
import com.pcloud.book.record.entity.BookBrowseRecord;
import com.pcloud.book.record.entity.BookMapStatistics;
import com.pcloud.book.record.entity.ClassifyStatistics;
import com.pcloud.common.core.dao.BaseDaoImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

/**
 * @ClassName com.pcloud.book.record.dao.impl.BookBrowseRecordDAOImpl
 * @Author 吴博
 * @Description 书刊浏览记录DAO
 * @Date 2020/6/16 10:49
 * @Version 1.0
 **/
@Repository("bookBrowseRecord")
public class BookBrowseRecordDAOImpl extends BaseDaoImpl<BookBrowseRecord> implements BookBrowseRecordDAO {

    @Override
    public int deleteByPrimaryKey(Long id) {
        return getSessionTemplate().delete(getStatement("deleteByPrimaryKey"), id);
    }

    @Override
    public int insertSelective(BookBrowseRecord record) {
        return getSessionTemplate().insert(getStatement("insertSelective"), record);
    }

    @Override
    public BookBrowseRecord selectByPrimaryKey(Long id) {
        return getSessionTemplate().selectOne(getStatement("selectByPrimaryKey"),id);
    }

    @Override
    public int updateByPrimaryKeySelective(BookBrowseRecord record) {
        return getSessionTemplate().update(getStatement("updateByPrimaryKeySelective"), record);
    }

    @Override
    public int updateByPrimaryKey(BookBrowseRecord record) {
        return getSessionTemplate().update(getStatement("updateByPrimaryKey"), record);

    }

    @Override
    public List<BookMapStatistics> getBookCount4Country(String regionCode) {
        return getSessionTemplate().selectList(getStatement("getBookCount4Country"), regionCode);
    }

    @Override
    public AreaStatistics getAreaStatistics(String regionCode, Integer areaCode) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("regionCode", regionCode);
        paramMap.put("areaCode", areaCode);
        return getSessionTemplate().selectOne(getStatement("getAreaStatistics"), paramMap);
    }

    @Override
    public List<ClassifyStatistics> getClassifyStatistics(String regionCode, Integer areaCode) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("regionCode", regionCode);
        paramMap.put("areaCode", areaCode);
        return getSessionTemplate().selectList(getStatement("getClassifyStatistics"), paramMap);
    }

    @Override
    public void getBookDetail(Map<String, Object> paramMap) {
        getSessionTemplate().selectList(getStatement("getBookDetail"), paramMap);
    }
}