package com.pcloud.book.skill.dao.impl;

import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import com.pcloud.book.skill.dao.PcloudGroupActivityDao;
import com.pcloud.book.skill.dto.GroupActivity4AppletDTO;
import com.pcloud.book.skill.entity.PcloudGroupActivity;
import com.pcloud.book.skill.facade.request.GroupActivityClassifyVO;
import com.pcloud.book.skill.facade.request.GroupActivityShowStateVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class PcloudGroupActivityDaoImpl extends BaseDaoImpl<PcloudGroupActivity> implements PcloudGroupActivityDao {

    @Override
    public Integer getCountByNumber(String number){
        return getSessionTemplate().selectOne(getStatement("getCountByNumber"), number);
    }

    @Override
    public void batchUpdateShowState(GroupActivityClassifyVO groupActivityClassifyVO) {
        Map<String,Object> map = new HashMap<>();
        map.put("ids", groupActivityClassifyVO.getIds());
        map.put("firstClassify", groupActivityClassifyVO.getFirstClassify());
        map.put("secondClassify", groupActivityClassifyVO.getSecondClassify());
        map.put("gradeLabelId", groupActivityClassifyVO.getGradeLabelId());
        map.put("subjectLabelId", groupActivityClassifyVO.getSubjectLabelId());
        getSessionTemplate().update(getStatement("batchUpdateClassify"), map);
    }

    @Override
    public void batchUpdateShowState(GroupActivityShowStateVO groupActivityShowStateVO){
        Map<String,Object> map = new HashMap<>();
        map.put("ids", groupActivityShowStateVO.getIds());
        map.put("showState", groupActivityShowStateVO.getShowState());
        getSessionTemplate().update(getStatement("batchUpdateShowState"), map);
    }

    @Override
    public  void deleteByIds(List<Long> ids){
        getSessionTemplate().update(getStatement("deleteByIds"), ids);
    }

    @Override
    public Map<Long, PcloudGroupActivity> mayByIds(List<Long> ids) {
        return super.getSqlSession().selectMap(getStatement("mayByIds"), ids,"id");
    }

    @Override
    public void updateByPrimaryKeySelective(PcloudGroupActivity entity) {
        this.getSqlSession().update("com.pcloud.book.skill.dao.impl.PcloudGroupActivityDaoImpl.updateByPrimaryKeySelective", entity);
    }

    @Override
    public GroupActivity4AppletDTO getGroupActivity4Applet(Long firstClassify,Long secondClassify,Long gradeLabelId,Long subjectLabelId) {
        Map<String, Object> map = new HashMap<>();
        map.put("firstClassify", firstClassify);
        map.put("secondClassify", secondClassify);
        map.put("gradeLabelId", gradeLabelId);
        map.put("subjectLabelId", subjectLabelId);
        return super.getSqlSession().selectOne(getStatement("getGroupActivity4Applet"), map);
    }

    @Override
    public List<GroupActivity4AppletDTO> getTishBookSchoolList(BaseTempletClassify baseTempletClassify, Integer limit) {
        Map<String, Object> map = new HashMap<>();
        map.put("firstClassify", baseTempletClassify.getFirstClassify());
        map.put("secondClassify", baseTempletClassify.getSecondClassify());
        map.put("gradeLabelId", baseTempletClassify.getGradeLabelId());
        map.put("subjectLabelId", baseTempletClassify.getSubjectLabelId());
        map.put("limit", (limit != null ? limit :10));
        return super.getSqlSession().selectList(getStatement("getTishBookSchoolList"), map);
    }

    @Override
    public Map<Long, GroupActivity4AppletDTO> getByIds(List<Long> list) {
        return super.getSqlSession().selectMap(getStatement("getByIds"), list,"id");
    }

    @Override
    public Map<Long, GroupActivity4AppletDTO> getGroupClassifyByIds(List<Long> list){
        return super.getSqlSession().selectMap(getStatement("getGroupClassifyByIds"), list,"id");
    }

    @Override
    public List<Long> getGroupClassifyIds(Map<String, Object> paraMap) {
        return super.getSqlSession().selectList("getGroupClassifyIds",paraMap);
    }

}
