package com.pcloud.book.skill.facade;

import com.pcloud.book.skill.biz.PcloudGroupActivityBiz;
import com.pcloud.book.skill.dto.UpdateActivityShowStateDTO;
import com.pcloud.book.skill.facade.request.GroupActivityClassifyVO;
import com.pcloud.book.skill.facade.request.GroupActivityShowStateVO;
import com.pcloud.book.skill.facade.request.SaveGroupActivityRequestVO;
import com.pcloud.book.skill.facade.request.UpdateGroupActivityRequestVO;
import com.pcloud.book.skill.facade.response.QueryGroupActivityResponseVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;


@RestController
@RequestMapping("groupActivity")
public class PcloudGroupActivityFacade {

    @Resource
    private PcloudGroupActivityBiz pcloudGroupActivityBiz;

    @PostMapping("saveGroupActivity")
    public ResponseDto<Void> saveGroupActivity(@RequestHeader("token") String token, @RequestBody SaveGroupActivityRequestVO vo) throws PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        vo.setUserId(partyId);
        pcloudGroupActivityBiz.saveGroupActivity(vo);
        return new ResponseDto<>();
    }

    @PostMapping("updateGroupActivity")
    public ResponseDto<Void> updateGroupActivity(@RequestHeader("token") String token, @RequestBody UpdateGroupActivityRequestVO vo) throws PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        vo.setUserId(partyId);
        pcloudGroupActivityBiz.updateGroupActivity(vo);
        return new ResponseDto<>();
    }

    @GetMapping("deleteGroupActivity")
    public ResponseDto<Void> deleteGroupActivity(@RequestHeader("token") String token, @RequestParam(value = "id") Long id) throws PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudGroupActivityBiz.deleteGroupActivity(id, partyId);
        return new ResponseDto<>();
    }

    @GetMapping("queryGroupActivity")
    public ResponseDto<PageBeanNew<QueryGroupActivityResponseVO>> queryGroupActivity(@RequestParam(value = "name", required = false) String name,
                                                                                     @RequestParam(value = "proLabelId", required = false) Long proLabelId,
                                                                                     @RequestParam(value = "purLabelId", required = false) Long purLabelId,
                                                                                     @RequestParam(value = "depLabelId", required = false) Long depLabelId,
                                                                                     @RequestParam(value = "joinType", required = false) Integer joinType,
                                                                                     @RequestParam(value = "firstClassify", required = false) Long firstClassify,
                                                                                     @RequestParam(value = "secondClassify", required = false) Long secondClassify,
                                                                                     @RequestParam(value = "gradeLabelId", required = false) Long gradeLabelId,
                                                                                     @RequestParam(value = "subjectLabelId", required = false) Long subjectLabelId,
                                                                                     @RequestParam("numPerPage") Integer numPerPage,
                                                                                     @RequestParam("currentPage")  Integer currentPage){
        return new ResponseDto<>(pcloudGroupActivityBiz.queryGroupActivity(name, proLabelId, purLabelId, depLabelId, joinType,firstClassify,secondClassify, gradeLabelId,subjectLabelId,numPerPage, currentPage));
    }

    @PostMapping("updateActivityShowState")
    public ResponseDto<Void> updateActivityShowState(@RequestHeader("token") String token, @RequestBody UpdateActivityShowStateDTO showStateDTO) throws PermissionException {
       SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudGroupActivityBiz.updateActivityShowState(showStateDTO);
        return new ResponseDto<>();
    }

}
