package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 外部书单(AppletOuterBooklist)实体类
 *
 * @author makejava
 * @since 2020-08-11 14:13:04
 */
@Data
public class AppletOuterBooklistDTO extends BaseDto {
    private static final long serialVersionUID = 799578639173080859L;
    
    private Long id;
    /**
    * 书单主题名称
    */
    private String booklistName;
    /**
    * 创建者名称
    */
    private String userName;
    /**
    * 摘要
    */
    private String digest;
    /**
    * 展示图
    */
    private String displayPic;
    /**
    * 出版社
    */
    private String publish;
    /**
    * 创建时间
    */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    /**
     * 外部书刊id
     */
    private List<Long> outerBookIdList;

    private Integer bookCounts;
    /**
     * 外部书刊列表
     */
    private List<AppletOuterBookDTO> outerBookDTOS;

    private Long agentId;

    /**
     * 书单推荐是否在小程序首页展示
     */
    private Integer isShowHome;
}