package com.pcloud.book.base.exception;

import com.pcloud.common.exceptions.BizException;

/**
 * 
 * @描述：看一看应用中心异常基础类
 * @作者：songx
 * @创建时间：2017年2月9日,上午9:56:35
 * @版本：1.0
 */
public class BookBizException extends BizException{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1392226036593222282L;

	/**
	 * 分页参数缺失
	 */
	public static final BookBizException PAGE_PARAM_DELETION = new BookBizException(110010001, "分页参数缺失~！");

	/**
	 * 执行成功
	 */
	public static final int SUCCESS = 0;
	
	/**
	 * 执行失败
	 */
	public static final int ERROR = 20210000;
	
	/**
	 * 参数为空
	 */
	public static final int PARAM_IS_NULL = 20210002;

	/**
	 * 库存为空
	 */
	public static final int STOCK_IS_EMPTY = 20210111;

	/**
	 * 已经领取过
	 */
	public static final int HAS_RECEIVED = 20210112;


	/**
	 * 时间格式错误
	 */
	public static final int TIME_FORMAT_ERROR = 20210003;		
	
	/**
	 * 文章转换错误
	 */
	public static final int ARTICLE_FORMAT_ERROR = 20210003;		
	
	/**
	 * id不存在
	 */
	public static final int ID_NOT_EXIST = 20210004;
	
	/**
	 * 必填字段为空
	 */
	public static final int FILED_NULL = 20210006;
	
	/**
	 * 数据库操作失败
	 */
	public static final int DB_DML_FAIL = 20210007;
	
	/**
	 * 调用用户中心失败
	 */
	public static final int INVOKE_USER_ERROR = 20210009;
	
	/**
	 * 调用資源中心失败
	 */
	public static final int INVOKE_RES_ERROR = 20210010;
	
	/**
	 * 调用微信中心失败
	 */
	public static final int INVOKE_WECHAT_ERROR = 20210011;
	
	/**
	 * 调用渠道中心失败
	 */
	public static final int INVOKE_CHANNEL_ERROR = 20210012;
	
	/**
	 * 调用定时任务中心失败
	 */
	public static final int INVOKE_QUARTZ_ERROR = 20210013;
	
	/**
	 * 不支持的编码格式
	 */
	public static final int UNSUPPORTED_ENCODE = 20210014;
	
	/**
	 * 时间比较错误
	 */
	public static final int TIME_COMPARE_ERROR = 20210015;
	
	/**
	 * 包含子集，不能删除
	 */
	public static final int DB_DELETE_FAIL = 20210016;
	
	/**
	 * 参数为错误
	 */
	public static final int PARAM_IS_ERROR = 20210017;
	
	/**
	 * 查询返回有数据
	 */
	public static final int DB_SELECT_MORE = 20210018;
	
	/**
	 * 返回结果没空
	 */
	public static final int RESULT_NULL = 20210019;
	
	/**
	 * 调用消息中心失败
	 */
	public static final int INVOKE_MESSAGE_ERROR = 20210020;
	
	/**
	 * 审核失败
	 */
	public static final int AUDIT_ERROR = 20210021;
	
	/**
	 * 发送Topic失败
	 */
	public static final int SEND_TOPIC_ERROR = 20210022;
	
	/**
	 * 消费Topic失败
	 */
	public static final int CONSUMER_TOPIC_ERROR = 20210023;
	

	/**
	 * 调用外部接口获取书籍信息失败
	 */
	public static final int GET_BOOKINFO_ERROR = 20210024;
	
	/**
	 * 本人已经添加过这本书
	 */
	public static final int HAVE_ADD_ERROR = 20210025;
	
	/**
	 * 参数已存在
	 */
	public static final int PARAM_IS_EXIST = 20210026;
	
	/**
	 * 频繁请求
	 */
	public static final int FREQUENTLY_REQUEST = 20210027;
	
	/**
	 * 调用应用中心失败
	 */
	public static final int INVOKE_APP_ERROR = 20210028;
	
	/**
	 * 调用内容失败
	 */
	public static final int INVOKE_CONTENT_ERROR = 20210029;
	
	/**
	 * 非法删除
	 */
	public static final int NO_DELETE_ERROR = 20210030;
	public BookBizException() {
		
	}

	public BookBizException(int code, String msgFormat, Object... args) {
		super(code, msgFormat, args);
	}
	
	public BookBizException(int code, String msg) {
		super(code, msg);
	}

}
