/**
 *
 */
package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @描述：书籍实体DTO
 * @作者：songx
 * @创建时间：2016年12月23日,下午2:30:06 @版本：1.0
 */
public class BookDto extends BaseDto {

    /**
     *
     */
    private static final long serialVersionUID = -162839217433038629L;

    /**
     * 书籍标识
     */
    private Long bookId;

    /**
     * 类型编码
     */
    private String typeCode;

    /**
     * 类型名称
     */
    private String typeName;

    /**
     * 书籍ISBN码
     */
    private String isbn;

    private Integer isDelete;

    /**
     * 书籍名称
     */
    private String bookName;

    /**
     * 书籍价格
     */
    private String bookPrice;

    /**
     * 图书原名
     */
    private String originName;

    /**
     * 简介
     */
    private String remark;

    /**
     * 作者
     */
    private String author;

    /**
     * 出版社
     */
    private String publish;

    /**
     * 出版时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date publishDate;

    /**
     * 封面图
     */
    private String coverImg;

    /**
     * 详情
     */
    private String detail;

    /**
     * 主办单位
     */
    private String sponsor;

    /**
     * 主管单位
     */
    private String organizer;

    /**
     * CN
     */
    private String cn;

    /**
     * 发行周期
     */
    private String releaseCycle;

    /**
     * 期物刊数
     */
    private String bookNum;

    /**
     * 栏目
     */
    private String programa;

    /**
     * 邮发代号
     */
    private String mailCode;

    /**
     * 地址
     */
    private String address;

    /**
     * 电话
     */
    private String telephone;

    /**
     * 邮箱
     */
    private String mail;

    /**
     * 宗旨
     */
    private String purpose;

    /**
     * 编辑标识
     */
    private Long adviserId;

    /**
     * 编辑名称
     */
    private String adviserName;

    /**
     * 渠道标识
     */
    private Long channelId;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 二维码数量
     */
    private Integer qrcodeCount;

    /**
     * 应用数量
     */
    private Integer appCount;

    /**
     * 作品数量
     */
    private Integer productCount;

    /**
     * 最新二维码
     */
    private String latestQrcode;

    /**
     * 应用列表
     */
    private List<Object> apps;

    /**
     * 作品列表
     */
    private List<Object> products;

    /**
     * 资源列表
     */
    private List<Object> resourceFiles;
    /**
     * 资源数量
     */
    private Integer resourceCount;

    /**
     * 第一次扫描时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date firstScanDate;

    /**
     * 首次来源二维码名称
     */
    private String firstSceneName;

    /**
     * 期刊号
     */
    private String issn;

    /**
     * 关联应用标识
     */
    private Long appId;

    /**
     * 刊物序号
     */
    private String serialNumber;

    /**
     * 是否加入书架
     */
    private Boolean isSelect;

    /**
     * 宣传图
     */
    private String adImg;

    /**
     * 是否是主编辑
     */
    private Boolean isMainEditor;

    /**
     * 主编辑名称
     */
    private String mainEditorName;

    /**
     * 主编辑头像
     */
    private String mainEditorPic;

    /**
     * 书刊是否有编辑关联
     */
    private Boolean isHaveAdviser;

    /**
     * 书刊是否有基金支持
     */
    private Boolean isFundSupport;

    /**
     * 书刊是否有基金
     */
    private Boolean isHaveFund;

    /**
     * 书籍扫描数
     */
    private Long bookScanCount;

    /**
     * 书籍二维码数
     */
    private Long bookQrCount;

    /**
     * 书刊读者数
     */
    private Integer readerCount;

    /**
     * 书刊总收益
     */
    private BigDecimal bookIncome;

    /**
     * 基金收益
     */
    private BigDecimal fundMoney;

    /**
     * 基金列表
     */
    private List<BookFundDto> bookFunds;

    /**
     * 出版类型
     */
    private Integer agentType;

    /**
     * 基金支持开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 基金支持结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 二维码标识
     */
    private Long sceneId;
    /**
     * 父模板标识
     */
    private Long templeParentId;

    /**
     * 模板标识
     */
    private Long templetId;

    /**
     * 模板名称
     */
    private String templetName;

    /**
     * 浏览量
     */
    private Long browseCounts;

    /**
     * 读者量
     */
    private Long browserCounts;

    /**
     * 扫描量
     */
    private Long scanCount;

    /**
     * 冻结状态
     */
    private Integer FreezeStatus;

    /**
     * 图书总收益
     */
    private BigDecimal income;

    /**
     * 编辑图书关联标识
     */
    private Long bookAdviserId;

    /**
     * 图书是否关二维码联
     */
    private Boolean relationQrcode;

    /**
     * 待审核数量
     */
    private Long noAuditNum;

    private String transferor;

    // 二维码相关信息

    private String qrcodeUrl;
    /**
     * 配置服务个数
     */
    private Integer messageCount;

    /**
     * 类型名称
     */
    private List<String> typeCodeNames;
    /**
     * 印码位置
     */
    private String location;
    /**
     * 二维码名字
     */
    private String sceneName;
    /**
     * 二维码导读字段
     */
    private String qrRemark;

    @ApiModelProperty("图书状态")
    private Integer bookStatus;

    /**
     * 是否开启广告位权限
     */
    private Boolean isOpen;

    /**
     * 出版ID
     */
    private Long agentId;

    /**
     * 出版社名称
     */
    private String agentName;

    /**
     * 投放时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date distributionTime;

    /**
     * 曝光量
     */
    private Long exposureNum;

    /**
     * 点击量
     */
    private Long clickNum;

    /**
     * 广告位数量
     */
    private Long advertisingSpaceNum;

    /**
     * 点击率
     */
    private BigDecimal clickRate;

    /**
     * 公众号名称
     */
    private String officialAccountsName;

    /**
     * 唯一编号
     */
    private String uniqueNumber;

    /**
     * 社群码数据
     */
    /**
     * 是否是社群书
     */
    private Boolean isBookGroup;

    /**
     * 社群码ID
     */
    private Long bookGroupId;

    /**
     * 社群码图片
     */
    private String groupQrcodeUrl;

    /**
     * 社群码名称
     */
    private String groupQrcodeName;

    /**
     * 社群码深度标签
     */
    private Long bookGroupDepLabelId;

    /**
     * 群分类数量
     */
    private Long classifyCount;

    /**
     * 群总人数
     */
    private Long groupPersonCount;

    /**
     * 群数量
     */
    private Long groupCount;

    /**
     * 累计收益
     */
    private BigDecimal totalIncome;

    /**
     * 社群码链接
     */
    private String groupQrcodeLink;

    /**
     * 第二级类型
     */
    private Long secondTempletId;

    /**
     * 第二类型名称
     */
    private String secondTempletName;


    /**
     * 第三级类型
     */
    private Long thirdTempletId;

    /**
     * 第三类型名称
     */
    private String thirdTempletName;

    /**
     * 第二级类型typeCode
     */
    private String secondTypeCode;

    /**
     * 报名量
     */
    private Long registerNum;
    /**
     * 报名率
     */
    private BigDecimal registerRate;
    /**
     * 点击读者量
     */
    private Long clickUserNum;

    /**
     * 试听完成人数（完课量）
     */
    private Long pilotFinishUserNum;

    /**
     * 试听完成比率（完课率）
     */
    private BigDecimal pilotFinishRate;

    /**
     * 平均浏览时长
     */
    private BigDecimal avgBrowseTimes;
    /**
     * 跳出量
     */
    private Long outNum;
    /**
     * 跳出率
     */
    private BigDecimal outRate;

    /**
     * 编辑手机号
     */
    private String phone;

    /**
     * 进群方式：1群二维码，2客服机器人
     */
    private Integer joinGroupType;
    /**
     * 好友人数
     */
    private Integer friendsCount;

    /**
     * 社群码暗号
     */
    private String bookGroupCipher;

    /**
     * 是否配置资源
     */
    private Boolean hasServe;

    /**
     * 书籍简称
     */
    private String shortBookName;


    /**
     * 年级标签id
     */
    private Long graLabelId;

    /**
     * 科目标签id
     */
    private Long subLabelId;

    /**
     * 版本标签id
     */
    private Long verLabelId;

    /**
     * 地域标签id
     */
    private Long areaLabelId;

    /**
     * 出版社收益
     */
    private BigDecimal agentIncome;

    /**
     * 编辑收益
     */
    private BigDecimal adviserIncome;

	/**
     * 是否已下印
     */
    private Boolean isPrint;
    /**
     * 是否配置了个人号关键词
     */
    private Boolean hasRobotKeyword;

    @ApiModelProperty("专业标签ID")
    private Long proLabelId;

    @ApiModelProperty("深度标签ID")
    private Long depLabelId;

    @ApiModelProperty("目的标签ID")
    private Long purLabelId;

    @ApiModelProperty("专业标签名称")
    private String proLabelName;

    @ApiModelProperty("深度标签名称")
    private String depLabelName;

    @ApiModelProperty("目的标签名称")
    private String purLabelName;

    @ApiModelProperty("书刊所有收益")
    private BigDecimal allBookIncome;

    public Integer getIsOpenRobotProcess() {
        return isOpenRobotProcess;
    }

    public void setIsOpenRobotProcess(Integer isOpenRobotProcess) {
        this.isOpenRobotProcess = isOpenRobotProcess;
    }

    private Integer isOpenRobotProcess;

    @ApiModelProperty("小睿分类编号")
    private Integer classifyId;

    /**
     * 上下册标签id
     */
    private Long volLabelId;
    /**
     * 是否独立活码群
     */
    private Boolean singleGroup;
    /**
     * 关联群
     */
    private Long relatedBookGroupId;
    /**
     * 关联群的社群码
     */
    private BookGroupDTO relatedBookGroup;

    /**
     * 全局唯一id
     */
    private String bookUniqueNumber;

    private String adviserAccount;

    private String adviserPwd;

    /**
     * 是否开启小睿流程
     */
    private Boolean openWeapp;
    /**
     * 年级标签
     */
    private String graLabelName;

    /**
     * 科目标签
     */
    private String subLabelName;

    /**
     * 版本标签
     */
    private String verLabelName;

    /**
     * 地域标签
     */
    private String areaLabelName;
    /**
     * 上下册标签
     */
    private String volLabelName;

    private Integer isLibraryBook;

    @ApiModelProperty("是否出版融合")
    private Integer isFuse;
    @ApiModelProperty("负责人")
    private String person;
    @ApiModelProperty("天猫")
    private String tmall;
    @ApiModelProperty("天猫口令")
    private String tmallWord;
    @ApiModelProperty("京东")
    private String jd;
    @ApiModelProperty("当当")
    private String dangdang;
    private String pinduoduo;
    private String weixin;
    @ApiModelProperty("出版社标识")
    private String logo;
    @ApiModelProperty("出版社介绍")
    private String desc;

    @ApiModelProperty("是否配有答案")
    private Boolean hasAnswer;
    @ApiModelProperty("答案订阅状态")
    private Boolean subscribeState;

    @ApiModelProperty("版次")
    private String edition;

    /**
     * 小睿码跳转类型（默认进小睿小程序）
     */
    private Integer jumpType;
    /**
     * 小睿码自定义跳转链接
     */
    private String jumpUrl;
    /**
     * 权益id
     */
    private Long rightsSettingId;
    /**
     * 书刊保底支持
     */
    private List<BookMinimumSupportDTO> bookMinimumSupports;
    /**
     * 书刊是否有保底支持
     */
    private Boolean minimumSupport;

    /**
     *扫公众号码是否推小程序链接
     */
    private Integer isSendMiniUrl;

    public Integer getIsSendMiniUrl() {
        return isSendMiniUrl;
    }

    public void setIsSendMiniUrl(Integer isSendMiniUrl) {
        this.isSendMiniUrl = isSendMiniUrl;
    }

    public Boolean getMinimumSupport() {
        return minimumSupport;
    }

    public void setMinimumSupport(Boolean minimumSupport) {
        this.minimumSupport = minimumSupport;
    }

    public List<BookMinimumSupportDTO> getBookMinimumSupports() {
        return bookMinimumSupports;
    }

    public void setBookMinimumSupports(List<BookMinimumSupportDTO> bookMinimumSupports) {
        this.bookMinimumSupports = bookMinimumSupports;
    }

    public Long getThirdTempletId() {
        return thirdTempletId;
    }

    public void setThirdTempletId(Long thirdTempletId) {
        this.thirdTempletId = thirdTempletId;
    }

    public String getThirdTempletName() {
        return thirdTempletName;
    }

    public void setThirdTempletName(String thirdTempletName) {
        this.thirdTempletName = thirdTempletName;
    }

    public Long getRightsSettingId() {
        return rightsSettingId;
    }

    public void setRightsSettingId(Long rightsSettingId) {
        this.rightsSettingId = rightsSettingId;
    }

    public Integer getJumpType() {
        return jumpType;
    }

    public void setJumpType(Integer jumpType) {
        this.jumpType = jumpType;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public String getEdition() {
        return edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }


    private BookAdviserDto bookAdviserDto;

    public BookAdviserDto getBookAdviserDto() {
        return bookAdviserDto;
    }

    public void setBookAdviserDto(BookAdviserDto bookAdviserDto) {
        this.bookAdviserDto = bookAdviserDto;
    }

    public Boolean getSubscribeState() {
        return subscribeState;
    }

    public void setSubscribeState(Boolean subscribeState) {
        this.subscribeState = subscribeState;
    }

    public Boolean getHasAnswer() {
        return hasAnswer;
    }

    public void setHasAnswer(Boolean hasAnswer) {
        this.hasAnswer = hasAnswer;
    }

    public Integer getIsFuse() {
        return isFuse;
    }

    public void setIsFuse(Integer isFuse) {
        this.isFuse = isFuse;
    }

    public String getPerson() {
        return person;
    }

    public void setPerson(String person) {
        this.person = person;
    }

    public String getTmall() {
        return tmall;
    }

    public void setTmall(String tmall) {
        this.tmall = tmall;
    }

    public String getTmallWord() {
        return tmallWord;
    }

    public void setTmallWord(String tmallWord) {
        this.tmallWord = tmallWord;
    }

    public String getJd() {
        return jd;
    }

    public void setJd(String jd) {
        this.jd = jd;
    }

    public String getDangdang() {
        return dangdang;
    }

    public void setDangdang(String dangdang) {
        this.dangdang = dangdang;
    }

    public String getPinduoduo() {
        return pinduoduo;
    }

    public void setPinduoduo(String pinduoduo) {
        this.pinduoduo = pinduoduo;
    }

    public String getWeixin() {
        return weixin;
    }

    public void setWeixin(String weixin) {
        this.weixin = weixin;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getIsLibraryBook() {
        return isLibraryBook;
    }

    public void setIsLibraryBook(Integer isLibraryBook) {
        this.isLibraryBook = isLibraryBook;
    }

    public String getGraLabelName() {
        return graLabelName;
    }

    public void setGraLabelName(String graLabelName) {
        this.graLabelName = graLabelName;
    }

    public String getSubLabelName() {
        return subLabelName;
    }

    public void setSubLabelName(String subLabelName) {
        this.subLabelName = subLabelName;
    }

    public String getVerLabelName() {
        return verLabelName;
    }

    public void setVerLabelName(String verLabelName) {
        this.verLabelName = verLabelName;
    }

    public String getAreaLabelName() {
        return areaLabelName;
    }

    public void setAreaLabelName(String areaLabelName) {
        this.areaLabelName = areaLabelName;
    }

    public String getVolLabelName() {
        return volLabelName;
    }

    public void setVolLabelName(String volLabelName) {
        this.volLabelName = volLabelName;
    }

    public String getBookUniqueNumber() {
        return bookUniqueNumber;
    }

    public void setBookUniqueNumber(String bookUniqueNumber) {
        this.bookUniqueNumber = bookUniqueNumber;
    }

    public BookGroupDTO getRelatedBookGroup() {
        return relatedBookGroup;
    }

    public void setRelatedBookGroup(BookGroupDTO relatedBookGroup) {
        this.relatedBookGroup = relatedBookGroup;
    }

    public Long getRelatedBookGroupId() {
        return relatedBookGroupId;
    }

    public void setRelatedBookGroupId(Long relatedBookGroupId) {
        this.relatedBookGroupId = relatedBookGroupId;
    }

    public Boolean getSingleGroup() {
        return singleGroup;
    }

    public void setSingleGroup(Boolean singleGroup) {
        this.singleGroup = singleGroup;
    }

    public Boolean getOpenWeapp() {
        return openWeapp;
    }

    public void setOpenWeapp(Boolean openWeapp) {
        this.openWeapp = openWeapp;
    }

    public Long getVolLabelId() {
        return volLabelId;
    }

    public void setVolLabelId(Long volLabelId) {
        this.volLabelId = volLabelId;
    }

    public Integer getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Integer classifyId) {
        this.classifyId = classifyId;
    }

    public String getQrRemark() {
        return qrRemark;
    }

    public void setQrRemark(String qrRemark) {
        this.qrRemark = qrRemark;
    }

    public String getSceneName() {
        return sceneName;
    }

    public void setSceneName(String sceneName) {
        this.sceneName = sceneName;
    }

    public String getQrcodeUrl() {
        return qrcodeUrl;
    }

    public void setQrcodeUrl(String qrcodeUrl) {
        this.qrcodeUrl = qrcodeUrl;
    }

    public Integer getMessageCount() {
        return messageCount;
    }

    public void setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getTransferor() {
        return transferor;
    }

    public void setTransferor(String transferor) {
        this.transferor = transferor;
    }

    public Long getNoAuditNum() {
        return noAuditNum;
    }

    public void setNoAuditNum(Long noAuditNum) {
        this.noAuditNum = noAuditNum;
    }

    public Integer getFreezeStatus() {
        return FreezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        FreezeStatus = freezeStatus;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getFirstSceneName() {
        return firstSceneName;
    }

    public void setFirstSceneName(String firstSceneName) {
        this.firstSceneName = firstSceneName;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getFirstScanDate() {
        return firstScanDate;
    }

    public void setFirstScanDate(Date firstScanDate) {
        this.firstScanDate = firstScanDate;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public String getAdviserName() {
        return adviserName;
    }

    public void setAdviserName(String adviserName) {
        this.adviserName = adviserName;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public List<Object> getProducts() {
        return products;
    }

    public void setProducts(List<Object> products) {
        this.products = products;
    }

    public Integer getQrcodeCount() {
        return qrcodeCount;
    }

    public void setQrcodeCount(Integer qrcodeCount) {
        this.qrcodeCount = qrcodeCount;
    }

    public Integer getAppCount() {
        return appCount;
    }

    public void setAppCount(Integer appCount) {
        this.appCount = appCount;
    }

    public Integer getProductCount() {
        return productCount;
    }

    public void setProductCount(Integer productCount) {
        this.productCount = productCount;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Boolean getSelect() {
        return isSelect;
    }

    public void setSelect(Boolean select) {
        isSelect = select;
    }

    public Boolean getMainEditor() {
        return isMainEditor;
    }

    public void setMainEditor(Boolean mainEditor) {
        isMainEditor = mainEditor;
    }

    public Boolean getHaveAdviser() {
        return isHaveAdviser;
    }

    public void setHaveAdviser(Boolean haveAdviser) {
        isHaveAdviser = haveAdviser;
    }

    public Boolean getFundSupport() {
        return isFundSupport;
    }

    public void setFundSupport(Boolean fundSupport) {
        isFundSupport = fundSupport;
    }

    public Boolean getHaveFund() {
        return isHaveFund;
    }

    public void setHaveFund(Boolean haveFund) {
        isHaveFund = haveFund;
    }

    public Boolean getOpen() {
        return isOpen;
    }

    public void setOpen(Boolean open) {
        isOpen = open;
    }

    public Boolean getBookGroup() {
        return isBookGroup;
    }

    public void setBookGroup(Boolean bookGroup) {
        isBookGroup = bookGroup;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getPublish() {
        return publish;
    }

    public void setPublish(String publish) {
        this.publish = publish;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public String getCoverImg() {
        return coverImg;
    }

    public void setCoverImg(String coverImg) {
        this.coverImg = coverImg;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getSponsor() {
        return sponsor;
    }

    public void setSponsor(String sponsor) {
        this.sponsor = sponsor;
    }

    public String getOrganizer() {
        return organizer;
    }

    public void setOrganizer(String organizer) {
        this.organizer = organizer;
    }

    public String getCn() {
        return cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }

    public String getReleaseCycle() {
        return releaseCycle;
    }

    public void setReleaseCycle(String releaseCycle) {
        this.releaseCycle = releaseCycle;
    }

    public String getBookNum() {
        return bookNum;
    }

    public void setBookNum(String bookNum) {
        this.bookNum = bookNum;
    }

    public String getPrograma() {
        return programa;
    }

    public void setPrograma(String programa) {
        this.programa = programa;
    }

    public String getMailCode() {
        return mailCode;
    }

    public void setMailCode(String mailCode) {
        this.mailCode = mailCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getMail() {
        return mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getOriginName() {
        return originName;
    }

    public void setOriginName(String originName) {
        this.originName = originName;
    }

    public String getBookPrice() {
        return bookPrice;
    }

    public void setBookPrice(String bookPrice) {
        this.bookPrice = bookPrice;
    }

    public String getIssn() {
        return issn;
    }

    public void setIssn(String issn) {
        this.issn = issn;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Boolean getIsSelect() {
        return isSelect;
    }

    public void setIsSelect(Boolean isSelect) {
        this.isSelect = isSelect;
    }

    public String getAdImg() {
        return adImg;
    }

    public void setAdImg(String adImg) {
        this.adImg = adImg;
    }

    public String getLatestQrcode() {
        return latestQrcode;
    }

    public void setLatestQrcode(String latestQrcode) {
        this.latestQrcode = latestQrcode;
    }

    public Boolean getIsMainEditor() {
        return isMainEditor;
    }

    public void setIsMainEditor(Boolean isMainEditor) {
        this.isMainEditor = isMainEditor;
    }

    public String getMainEditorName() {
        return mainEditorName;
    }

    public void setMainEditorName(String mainEditorName) {
        this.mainEditorName = mainEditorName;
    }

    public String getMainEditorPic() {
        return mainEditorPic;
    }

    public void setMainEditorPic(String mainEditorPic) {
        this.mainEditorPic = mainEditorPic;
    }

    public Boolean getIsHaveAdviser() {
        return isHaveAdviser;
    }

    public void setIsHaveAdviser(Boolean isHaveAdviser) {
        this.isHaveAdviser = isHaveAdviser;
    }

    public Long getBookScanCount() {
        return bookScanCount;
    }

    public void setBookScanCount(Long bookScanCount) {
        this.bookScanCount = bookScanCount;
    }

    public Long getBookQrCount() {
        return bookQrCount;
    }

    public void setBookQrCount(Long bookQrCount) {
        this.bookQrCount = bookQrCount;
    }

    public Boolean getIsFundSupport() {
        return isFundSupport;
    }

    public void setIsFundSupport(Boolean isFundSupport) {
        this.isFundSupport = isFundSupport;
    }

    public Integer getReaderCount() {
        return readerCount;
    }

    public void setReaderCount(Integer readerCount) {
        this.readerCount = readerCount;
    }

    public BigDecimal getBookIncome() {
        return bookIncome;
    }

    public void setBookIncome(BigDecimal bookIncome) {
        this.bookIncome = bookIncome;
    }

    public BigDecimal getFundMoney() {
        return fundMoney;
    }

    public void setFundMoney(BigDecimal fundMoney) {
        this.fundMoney = fundMoney;
    }

    public Boolean getIsHaveFund() {
        return isHaveFund;
    }

    public void setIsHaveFund(Boolean isHaveFund) {
        this.isHaveFund = isHaveFund;
    }

    public List<BookFundDto> getBookFunds() {
        return bookFunds;
    }

    public void setBookFunds(List<BookFundDto> bookFunds) {
        this.bookFunds = bookFunds;
    }

    public Integer getAgentType() {
        return agentType;
    }

    public void setAgentType(Integer agentType) {
        this.agentType = agentType;
    }

    public List<Object> getApps() {
        return apps;
    }

    public void setApps(List<Object> apps) {
        this.apps = apps;
    }

    public List<Object> getResourceFiles() {
        return resourceFiles;
    }

    public void setResourceFiles(List<Object> resourceFiles) {
        this.resourceFiles = resourceFiles;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public Long getTempletId() {
        return templetId;
    }

    public void setTempletId(Long templetId) {
        this.templetId = templetId;
    }

    public String getTempletName() {
        return templetName;
    }

    public void setTempletName(String templetName) {
        this.templetName = templetName;
    }

    public Long getBrowseCounts() {
        return browseCounts;
    }

    public void setBrowseCounts(Long browseCounts) {
        this.browseCounts = browseCounts;
    }

    public Long getBrowserCounts() {
        return browserCounts;
    }

    public void setBrowserCounts(Long browserCounts) {
        this.browserCounts = browserCounts;
    }

    public Long getScanCount() {
        return scanCount;
    }

    public void setScanCount(Long scanCount) {
        this.scanCount = scanCount;
    }

    public BigDecimal getIncome() {
        return income;
    }

    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    public Long getBookAdviserId() {
        return bookAdviserId;
    }

    public void setBookAdviserId(Long bookAdviserId) {
        this.bookAdviserId = bookAdviserId;
    }

    public Boolean getRelationQrcode() {
        return relationQrcode;
    }

    public void setRelationQrcode(Boolean relationQrcode) {
        this.relationQrcode = relationQrcode;
    }

    public Long getTempleParentId() {
        return templeParentId;
    }

    public void setTempleParentId(Long templeParentId) {
        this.templeParentId = templeParentId;
    }

    public List<String> getTypeCodeNames() {
        return typeCodeNames;
    }

    public void setTypeCodeNames(List<String> typeCodeNames) {
        this.typeCodeNames = typeCodeNames;
    }

    public Integer getBookStatus() {
        return bookStatus;
    }

    public void setBookStatus(Integer bookStatus) {
        this.bookStatus = bookStatus;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Date getDistributionTime() {
        return distributionTime;
    }

    public void setDistributionTime(Date distributionTime) {
        this.distributionTime = distributionTime;
    }

    public Long getExposureNum() {
        return exposureNum;
    }

    public void setExposureNum(Long exposureNum) {
        this.exposureNum = exposureNum;
    }

    public Long getClickNum() {
        return clickNum;
    }

    public void setClickNum(Long clickNum) {
        this.clickNum = clickNum;
    }

    public String getOfficialAccountsName() {
        return officialAccountsName;
    }

    public void setOfficialAccountsName(String officialAccountsName) {
        this.officialAccountsName = officialAccountsName;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public String getGroupQrcodeUrl() {
        return groupQrcodeUrl;
    }

    public void setGroupQrcodeUrl(String groupQrcodeUrl) {
        this.groupQrcodeUrl = groupQrcodeUrl;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public String getUniqueNumber() {
        return uniqueNumber;
    }

    public void setUniqueNumber(String uniqueNumber) {
        this.uniqueNumber = uniqueNumber;
    }

    public Long getClassifyCount() {
        return classifyCount;
    }

    public void setClassifyCount(Long classifyCount) {
        this.classifyCount = classifyCount;
    }

    public Long getGroupPersonCount() {
        return groupPersonCount;
    }

    public void setGroupPersonCount(Long groupPersonCount) {
        this.groupPersonCount = groupPersonCount;
    }

    public Long getGroupCount() {
        return groupCount;
    }

    public void setGroupCount(Long groupCount) {
        this.groupCount = groupCount;
    }

    public BigDecimal getTotalIncome() {
        return totalIncome;
    }

    public void setTotalIncome(BigDecimal totalIncome) {
        this.totalIncome = totalIncome;
    }

    public String getGroupQrcodeLink() {
        return groupQrcodeLink;
    }

    public void setGroupQrcodeLink(String groupQrcodeLink) {
        this.groupQrcodeLink = groupQrcodeLink;
    }

    public Long getSecondTempletId() {
        return secondTempletId;
    }

    public void setSecondTempletId(Long secondTempletId) {
        this.secondTempletId = secondTempletId;
    }

    public String getSecondTempletName() {
        return secondTempletName;
    }

    public void setSecondTempletName(String secondTempletName) {
        this.secondTempletName = secondTempletName;
    }

    public String getSecondTypeCode() {
        return secondTypeCode;
    }

    public void setSecondTypeCode(String secondTypeCode) {
        this.secondTypeCode = secondTypeCode;
    }

    public Boolean getIsBookGroup() {
        return isBookGroup;
    }

    public void setIsBookGroup(Boolean isBookGroup) {
        this.isBookGroup = isBookGroup;
    }

    public BigDecimal getClickRate() {
        return clickRate;
    }

    public void setClickRate(BigDecimal clickRate) {
        this.clickRate = clickRate;
    }

    public Long getAdvertisingSpaceNum() {
        return advertisingSpaceNum;
    }

    public void setAdvertisingSpaceNum(Long advertisingSpaceNum) {
        this.advertisingSpaceNum = advertisingSpaceNum;
    }

    public Long getBookGroupDepLabelId() {
        return bookGroupDepLabelId;
    }

    public void setBookGroupDepLabelId(Long bookGroupDepLabelId) {
        this.bookGroupDepLabelId = bookGroupDepLabelId;
    }

    public Long getRegisterNum() {
        return registerNum;
    }

    public void setRegisterNum(Long registerNum) {
        this.registerNum = registerNum;
    }

    public BigDecimal getRegisterRate() {
        return registerRate;
    }

    public void setRegisterRate(BigDecimal registerRate) {
        this.registerRate = registerRate;
    }

    public Long getClickUserNum() {
        return clickUserNum;
    }

    public void setClickUserNum(Long clickUserNum) {
        this.clickUserNum = clickUserNum;
    }

    public Long getPilotFinishUserNum() {
        return pilotFinishUserNum;
    }

    public void setPilotFinishUserNum(Long pilotFinishUserNum) {
        this.pilotFinishUserNum = pilotFinishUserNum;
    }

    public BigDecimal getPilotFinishRate() {
        return pilotFinishRate;
    }

    public void setPilotFinishRate(BigDecimal pilotFinishRate) {
        this.pilotFinishRate = pilotFinishRate;
    }

    public BigDecimal getAvgBrowseTimes() {
        return avgBrowseTimes;
    }

    public void setAvgBrowseTimes(BigDecimal avgBrowseTimes) {
        this.avgBrowseTimes = avgBrowseTimes;
    }

    public Long getOutNum() {
        return outNum;
    }

    public void setOutNum(Long outNum) {
        this.outNum = outNum;
    }

    public BigDecimal getOutRate() {
        return outRate;
    }

    public void setOutRate(BigDecimal outRate) {
        this.outRate = outRate;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getJoinGroupType() {
        return joinGroupType;
    }

    public void setJoinGroupType(Integer joinGroupType) {
        this.joinGroupType = joinGroupType;
    }

    public Integer getFriendsCount() {
        return friendsCount;
    }

    public void setFriendsCount(Integer friendsCount) {
        this.friendsCount = friendsCount;
    }

    public String getBookGroupCipher() {
        return bookGroupCipher;
    }

    public void setBookGroupCipher(String bookGroupCipher) {
        this.bookGroupCipher = bookGroupCipher;
    }

    public Boolean getHasServe() {
        return hasServe;
    }

    public void setHasServe(Boolean hasServe) {
        this.hasServe = hasServe;
    }

    public String getShortBookName() {
        return shortBookName;
    }

    public void setShortBookName(String shortBookName) {
        this.shortBookName = shortBookName;
    }

    public Long getGraLabelId() {
        return graLabelId;
    }

    public void setGraLabelId(Long graLabelId) {
        this.graLabelId = graLabelId;
    }

    public Long getSubLabelId() {
        return subLabelId;
    }

    public void setSubLabelId(Long subLabelId) {
        this.subLabelId = subLabelId;
    }

    public Long getVerLabelId() {
        return verLabelId;
    }

    public void setVerLabelId(Long verLabelId) {
        this.verLabelId = verLabelId;
    }

    public Long getAreaLabelId() {
        return areaLabelId;
    }

    public void setAreaLabelId(Long areaLabelId) {
        this.areaLabelId = areaLabelId;
    }

    public BigDecimal getAgentIncome() {
        return agentIncome;
    }

    public void setAgentIncome(BigDecimal agentIncome) {
        this.agentIncome = agentIncome;
    }

    public BigDecimal getAdviserIncome() {
        return adviserIncome;
    }

    public void setAdviserIncome(BigDecimal adviserIncome) {
        this.adviserIncome = adviserIncome;
    }
	
	public Boolean getIsPrint() {
        return isPrint;
    }

    public void setIsPrint(Boolean isPrint) {
        this.isPrint = isPrint;
    }

    public Boolean getHasRobotKeyword() {
        return hasRobotKeyword;
    }

    public void setHasRobotKeyword(Boolean hasRobotKeyword) {
        this.hasRobotKeyword = hasRobotKeyword;
    }

    public Integer getResourceCount() {
        return resourceCount;
    }

    public void setResourceCount(Integer resourceCount) {
        this.resourceCount = resourceCount;
    }

    public Long getProLabelId() {
        return proLabelId;
    }

    public void setProLabelId(Long proLabelId) {
        this.proLabelId = proLabelId;
    }

    public Long getDepLabelId() {
        return depLabelId;
    }

    public void setDepLabelId(Long depLabelId) {
        this.depLabelId = depLabelId;
    }

    public Long getPurLabelId() {
        return purLabelId;
    }

    public void setPurLabelId(Long purLabelId) {
        this.purLabelId = purLabelId;
    }

    public String getProLabelName() {
        return proLabelName;
    }

    public void setProLabelName(String proLabelName) {
        this.proLabelName = proLabelName;
    }

    public String getDepLabelName() {
        return depLabelName;
    }

    public void setDepLabelName(String depLabelName) {
        this.depLabelName = depLabelName;
    }

    public String getPurLabelName() {
        return purLabelName;
    }

    public void setPurLabelName(String purLabelName) {
        this.purLabelName = purLabelName;
    }

    public BigDecimal getAllBookIncome() {
        return allBookIncome;
    }

    public void setAllBookIncome(BigDecimal allBookIncome) {
        this.allBookIncome = allBookIncome;
    }

    public String getAdviserAccount() {
        return adviserAccount;
    }

    public void setAdviserAccount(String adviserAccount) {
        this.adviserAccount = adviserAccount;
    }

    public String getAdviserPwd() {
        return adviserPwd;
    }

    public void setAdviserPwd(String adviserPwd) {
        this.adviserPwd = adviserPwd;
    }

    @Override
    public String toString() {
        return "BookDto{" +
                "bookId=" + bookId +
                ", typeCode='" + typeCode + '\'' +
                ", typeName='" + typeName + '\'' +
                ", isbn='" + isbn + '\'' +
                ", isDelete=" + isDelete +
                ", bookName='" + bookName + '\'' +
                ", bookPrice='" + bookPrice + '\'' +
                ", originName='" + originName + '\'' +
                ", remark='" + remark + '\'' +
                ", author='" + author + '\'' +
                ", publish='" + publish + '\'' +
                ", publishDate=" + publishDate +
                ", coverImg='" + coverImg + '\'' +
                ", detail='" + detail + '\'' +
                ", sponsor='" + sponsor + '\'' +
                ", organizer='" + organizer + '\'' +
                ", cn='" + cn + '\'' +
                ", releaseCycle='" + releaseCycle + '\'' +
                ", bookNum='" + bookNum + '\'' +
                ", programa='" + programa + '\'' +
                ", mailCode='" + mailCode + '\'' +
                ", address='" + address + '\'' +
                ", telephone='" + telephone + '\'' +
                ", mail='" + mail + '\'' +
                ", purpose='" + purpose + '\'' +
                ", adviserId=" + adviserId +
                ", adviserName='" + adviserName + '\'' +
                ", channelId=" + channelId +
                ", channelName='" + channelName + '\'' +
                ", qrcodeCount=" + qrcodeCount +
                ", appCount=" + appCount +
                ", productCount=" + productCount +
                ", latestQrcode='" + latestQrcode + '\'' +
                ", apps=" + apps +
                ", products=" + products +
                ", resourceFiles=" + resourceFiles +
                ", resourceCount=" + resourceCount +
                ", firstScanDate=" + firstScanDate +
                ", firstSceneName='" + firstSceneName + '\'' +
                ", issn='" + issn + '\'' +
                ", appId=" + appId +
                ", serialNumber='" + serialNumber + '\'' +
                ", isSelect=" + isSelect +
                ", adImg='" + adImg + '\'' +
                ", isMainEditor=" + isMainEditor +
                ", mainEditorName='" + mainEditorName + '\'' +
                ", mainEditorPic='" + mainEditorPic + '\'' +
                ", isHaveAdviser=" + isHaveAdviser +
                ", isFundSupport=" + isFundSupport +
                ", isHaveFund=" + isHaveFund +
                ", bookScanCount=" + bookScanCount +
                ", bookQrCount=" + bookQrCount +
                ", readerCount=" + readerCount +
                ", bookIncome=" + bookIncome +
                ", fundMoney=" + fundMoney +
                ", bookFunds=" + bookFunds +
                ", agentType=" + agentType +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", sceneId=" + sceneId +
                ", templeParentId=" + templeParentId +
                ", templetId=" + templetId +
                ", templetName='" + templetName + '\'' +
                ", browseCounts=" + browseCounts +
                ", browserCounts=" + browserCounts +
                ", scanCount=" + scanCount +
                ", FreezeStatus=" + FreezeStatus +
                ", income=" + income +
                ", bookAdviserId=" + bookAdviserId +
                ", relationQrcode=" + relationQrcode +
                ", noAuditNum=" + noAuditNum +
                ", transferor='" + transferor + '\'' +
                ", qrcodeUrl='" + qrcodeUrl + '\'' +
                ", messageCount=" + messageCount +
                ", typeCodeNames=" + typeCodeNames +
                ", location='" + location + '\'' +
                ", sceneName='" + sceneName + '\'' +
                ", qrRemark='" + qrRemark + '\'' +
                ", bookStatus=" + bookStatus +
                ", isOpen=" + isOpen +
                ", agentId=" + agentId +
                ", agentName='" + agentName + '\'' +
                ", distributionTime=" + distributionTime +
                ", exposureNum=" + exposureNum +
                ", clickNum=" + clickNum +
                ", advertisingSpaceNum=" + advertisingSpaceNum +
                ", clickRate=" + clickRate +
                ", officialAccountsName='" + officialAccountsName + '\'' +
                ", uniqueNumber='" + uniqueNumber + '\'' +
                ", isBookGroup=" + isBookGroup +
                ", bookGroupId=" + bookGroupId +
                ", groupQrcodeUrl='" + groupQrcodeUrl + '\'' +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", bookGroupDepLabelId=" + bookGroupDepLabelId +
                ", classifyCount=" + classifyCount +
                ", groupPersonCount=" + groupPersonCount +
                ", groupCount=" + groupCount +
                ", totalIncome=" + totalIncome +
                ", groupQrcodeLink='" + groupQrcodeLink + '\'' +
                ", secondTempletId=" + secondTempletId +
                ", secondTempletName='" + secondTempletName + '\'' +
                ", secondTypeCode='" + secondTypeCode + '\'' +
                ", registerNum=" + registerNum +
                ", registerRate=" + registerRate +
                ", clickUserNum=" + clickUserNum +
                ", pilotFinishUserNum=" + pilotFinishUserNum +
                ", pilotFinishRate=" + pilotFinishRate +
                ", avgBrowseTimes=" + avgBrowseTimes +
                ", outNum=" + outNum +
                ", outRate=" + outRate +
                ", phone='" + phone + '\'' +
                ", joinGroupType=" + joinGroupType +
                ", friendsCount=" + friendsCount +
                ", bookGroupCipher='" + bookGroupCipher + '\'' +
                ", hasServe=" + hasServe +
                ", shortBookName='" + shortBookName + '\'' +
                ", graLabelId=" + graLabelId +
                ", subLabelId=" + subLabelId +
                ", verLabelId=" + verLabelId +
                ", areaLabelId=" + areaLabelId +
                ", agentIncome=" + agentIncome +
                ", adviserIncome=" + adviserIncome +
                ", isPrint=" + isPrint +
                ", hasRobotKeyword=" + hasRobotKeyword +
                ", proLabelId=" + proLabelId +
                ", depLabelId=" + depLabelId +
                ", purLabelId=" + purLabelId +
                ", proLabelName='" + proLabelName + '\'' +
                ", depLabelName='" + depLabelName + '\'' +
                ", purLabelName='" + purLabelName + '\'' +
                ", allBookIncome=" + allBookIncome +
                ", isOpenRobotProcess=" + isOpenRobotProcess +
                ", classifyId=" + classifyId +
                ", volLabelId=" + volLabelId +
                ", singleGroup=" + singleGroup +
                ", relatedBookGroupId=" + relatedBookGroupId +
                ", relatedBookGroup=" + relatedBookGroup +
                ", bookUniqueNumber='" + bookUniqueNumber + '\'' +
                ", adviserAccount='" + adviserAccount + '\'' +
                ", adviserPwd='" + adviserPwd + '\'' +
                ", openWeapp=" + openWeapp +
                ", graLabelName='" + graLabelName + '\'' +
                ", subLabelName='" + subLabelName + '\'' +
                ", verLabelName='" + verLabelName + '\'' +
                ", areaLabelName='" + areaLabelName + '\'' +
                ", volLabelName='" + volLabelName + '\'' +
                ", isLibraryBook=" + isLibraryBook +
                ", isFuse=" + isFuse +
                ", person='" + person + '\'' +
                ", tmall='" + tmall + '\'' +
                ", tmallWord='" + tmallWord + '\'' +
                ", jd='" + jd + '\'' +
                ", dangdang='" + dangdang + '\'' +
                ", pinduoduo='" + pinduoduo + '\'' +
                ", weixin='" + weixin + '\'' +
                ", logo='" + logo + '\'' +
                ", desc='" + desc + '\'' +
                ", hasAnswer=" + hasAnswer +
                ", subscribeState=" + subscribeState +
                ", edition='" + edition + '\'' +
                ", jumpType=" + jumpType +
                ", jumpUrl='" + jumpUrl + '\'' +
                ", rightsSettingId=" + rightsSettingId +
                ", bookMinimumSupports=" + bookMinimumSupports +
                ", minimumSupport=" + minimumSupport +
                ", bookAdviserDto=" + bookAdviserDto +
                '}';
    }
}
