package com.pcloud.book.book.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 序号自动生成表(BookSerialNumber)实体类
 *
 * @author makejava
 * @since 2020-08-26 13:58:55
 */
@Data
public class BookSerialNumber extends BaseEntity {

    private static final long serialVersionUID = -95051806019576407L;

    private Long id;

    @ApiModelProperty("isbn")
    private String isbn;

    @ApiModelProperty("序号")
    private Long serialNumber;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
}
