package com.pcloud.book.copyright.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author lily
 * @date 2018/12/3 11:11
 */
@ApiModel
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookAuthUserDTO {
    @ApiModelProperty("图书授权用户标识")
    private Long id;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("微信用户标识")
    private Long wechatUserId;

    @ApiModelProperty("用户名称")
    private String nickName;

    @ApiModelProperty("是否授权码进来用户（0 授权码 1 授权金购买")
    private Integer isAuthCode;

    @ApiModelProperty("月份")
    private String months;

    @ApiModelProperty("省份")
    private String province;

    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("创建时间带时分秒")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createdTime;

    @ApiModelProperty("创建人")
    private Long createdUser;

    @ApiModelProperty("创建时间不带时分秒")
    private Date createdDate;

    @ApiModelProperty("最后修改人")
    private Long lastModifiedUser;

    @ApiModelProperty("最后修改时间")
    private Date lastModifiedDate;

    @ApiModelProperty("是否是现代纸书")
    private Integer isPaperBook;

    @ApiModelProperty("是否是社群书")
    private Integer isGroupBook;

    @ApiModelProperty("授权码id")
    private Long bookAuthCodeId;
}
