package com.pcloud.book.cultivate.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.xml.bind.annotation.XmlElement;
import java.util.Date;


@Data
@ApiModel("小睿站内信发送")
public class CultivateNotifySend extends BaseEntity {

    @ApiModelProperty("消息id")
    private Long messageId;

    @ApiModelProperty("用户wxId")
    private String wxUserId;

    @ApiModelProperty("用户微信id")
    private Long wechatUserId;

    @ApiModelProperty("发送类型（1-指定用户，2-分类用户，3-按书籍查询，4-全局公告消息）")
    private Integer sendType;

    @ApiModelProperty("消息类型（1-系统消息，2-通知消息，3-提醒消息，4-活动消息）")
    private Integer messageType;

    @ApiModelProperty("是否已读1-是，0-否")
    private Boolean isRead;

    @ApiModelProperty("阅读时间")
    private Date readTime;

    @ApiModelProperty("标题")
    private String title;

    @JSONField(
            format = "yyyy-MM-dd HH:mm:ss"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @XmlElement
    public Date getReadTime() {
        return this.createTime;
    }

    public void setReadTime(Date readTime) {
        this.readTime = readTime;
    }

}
