package com.pcloud.book.es.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * ES查询结果封装
 *
 * @author guiq
 * @version 1.0
 * @since 2020年7月10日
 */
@Data
@ApiModel("ES查询结果封装")
public class ESBookGroupQrcodeDTO implements Serializable {

    private static final long serialVersionUID = -5540575837873167880L;
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("分类标识")
    private Long classifyId;

    @ApiModelProperty("群名称")
    private String groupName;

    @ApiModelProperty("序号")
    private Integer groupSeq;

    @ApiModelProperty("群人数")
    private Integer userNumber;

    @ApiModelProperty("微信群标识")
    private Integer weixinQrcodeId;

    @ApiModelProperty("微信群id")
    private String weixinGroupId;

    @ApiModelProperty("微信群头像")
    private String qrcodeHeadUrl;

    @ApiModelProperty("二维码地址")
    private String qrcodeUrl;

    @ApiModelProperty("使用状态1：已使用（人数未满）  2：人数已满")
    private Integer useState;

    @ApiModelProperty("群二维码状态（1 使用中 2 达到限制）")
    private Integer qrcodeState;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("最后修改人")
    private Long updateUser;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("0:未删除  1:已删除")
    private Integer isDelete;

    @ApiModelProperty("猜谜语是否开启")
    private Integer riddleOpen;

    @ApiModelProperty("城市标签")
    private List<String> cityTags;

    @ApiModelProperty("群名标签")
    private List<String> groupNameTags;

    @ApiModelProperty("书名标签")
    private List<String> bookNameTags;

    @ApiModelProperty("出版社地区标签")
    private List<String> pressTags;

    @ApiModelProperty("男性人数")
    private Integer maleCount;

    @ApiModelProperty("女性人数")
    private Integer femaleCount;

    @ApiModelProperty("未知性别人数")
    private Integer unknownCount;
}
