package com.pcloud.book.giftcoupon.service;

import com.pcloud.book.giftcoupon.vo.GiftCouponVo;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@FeignClient(value = "pcloud-service-book", qualifier = "giftCouponServiceCloud", path = "book/v1.0/giftCouponService")
@Api(description = "小程序劵包")
public interface GiftCouponService {

    @ApiOperation(value = "拿券的基本信息", httpMethod = "POST")
    @RequestMapping(value = "/getCouponBaseInfo", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<GiftCouponVo>> getCouponBaseInfo(@RequestParam("couponId") Long couponId) throws BizException;


    @ApiOperation(value = "签到奖励获取书币兑换券", httpMethod = "POST")
    @RequestMapping(value = "/getCoupon4Sign", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<GiftCouponVo>> getCoupon4Sign();
}
