package com.pcloud.book.group.enums;

import com.pcloud.common.utils.string.StringUtil;

public enum LargeTempletEnum {
    /**
     * K12类
     */
    K12(1, "K12类"),

    /**
     * 少儿类
     */
    CHILD(2, "少儿类"),
    /**
     * 高等/职教
     */
    HIGH(3, "高等/职教"),
    /**
     * 大众类
     */
    GENERAL(4, "大众类"),
    /**
     * 特殊出版社类
     */
    SPECIAL_AGENT(5, "特殊出版社"),
    /**
     * 小睿-微信
     */
    XIAORUI(6,"小睿（微信）"),

    /**
     * 小睿-QQ
     */
    XIAORUI_QQ(7,"小睿（QQ）");


    public final Integer code;

    public final String name;

    LargeTempletEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByCode(Integer code) {
        if (code==null) {
            return null;
        }
        LargeTempletEnum[] all = values();
        int length = all.length;
        for (int i = 0; i < length; ++i) {
            LargeTempletEnum largeTempletEnum = all[i];
            if (largeTempletEnum.code.equals(code)) {
                return largeTempletEnum.name;
            }
        }
        return null;
    }

}
