package com.pcloud.book.group.service;

import com.pcloud.book.group.dto.BookWxQrcodeDTO;
import com.pcloud.book.group.dto.GroupQrcodeInfo4Advertising;
import com.pcloud.book.group.dto.MaterialMigrateDTO;
import com.pcloud.book.group.dto.SearchDto;
import com.pcloud.book.group.dto.SyncWeixinGroupIdDTO;
import com.pcloud.book.group.dto.UpdateQrDTO;
import com.pcloud.book.group.dto.WeixinQrcodeCountDTO;
import com.pcloud.book.group.dto.WeixinQrcodeDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/19 15:57
 */
@FeignClient(value = "pcloud-service-book", qualifier = "weixinQrcodeServiceCloud", path = "book/v1.0/weixinQrcodeService")
@Api(description = "微信群二维码码接口")
public interface WeixinQrcodeService {

    @ApiOperation("定时任务")
    @GetMapping("tenQuartz")
    void tenQuartz() throws BizException;

    @ApiOperation("发起更新二维码请求")
    @GetMapping("setUpdateQrUrl")
    void setUpdateQrUrl() throws BizException;

    @ApiOperation("更新二维码地址")
    @GetMapping("updateQrUrl")
    void updateQrUrl(UpdateQrDTO updateQrDTO) throws BizException;

    @ApiOperation("针对出错的二维码发起更新二维码请求")
    @GetMapping("setUpdateQr4Error")
    void setUpdateQr4Error(List<Long> ids) throws BizException;

    @ApiOperation("同步微信群id")
    @PostMapping("syncWeixinGroupId")
    void syncWeixinGroupId(@RequestBody SyncWeixinGroupIdDTO syncWeixinGroupIdDTO);

    @ApiOperation("发送修改群名称请求")
    @PostMapping("sendChangeGroupNameRequest")
    void sendChangeGroupNameRequest(@RequestBody(required = false) List<Long> ids);

    @ApiOperation("发送同步微信id的请求")
    @PostMapping("sendSyncWeixinGroupIdRequest")
    void sendSyncWeixinGroupIdRequest(@RequestBody List<Long> ids);

    @ApiOperation("获取机器人二维码分配情况")
    @PostMapping("listWeixinQrcodeCountByRobot")
    ResponseEntity<ResponseDto<Map<Long, WeixinQrcodeCountDTO>>> listWeixinQrcodeCountByRobot(@RequestBody List<Long> robotIds);

    @ApiOperation("获取一个二维码")
    @GetMapping("getOneQrcode")
    ResponseEntity<ResponseDto<WeixinQrcodeDTO>> getOneQrcode();

    @ApiOperation("分页获取可用微信群")
    @GetMapping("listAvailableGroupByPage")
    ResponseEntity<ResponseDto<List<BookWxQrcodeDTO>>> listAvailableGroupByPage(@RequestParam("currentPage") Integer currentPage, @RequestParam("numPerPage") Integer numPerPage);

    @ApiOperation("分页获取人数超过10人的可用微信群")
    @GetMapping("listOver10AvailableGroupByPage")
    ResponseEntity<ResponseDto<List<BookWxQrcodeDTO>>> listOver10AvailableGroupByPage(@RequestParam("currentPage") Integer currentPage, @RequestParam("numPerPage") Integer numPerPage);

    @ApiOperation("所有群邀请新的机器人小号(有接收消息机器人存在好友关系)")
    @GetMapping("inviteNewRobot")
    void inviteNewRobot(@RequestParam("wxUserId") String wxUserId);

    @ApiOperation(value = "通过群id获取群版本信息", httpMethod = "GET")
    @RequestMapping(value = "getGroupVersionIp", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<String, BookWxQrcodeDTO>>> getGroupVersionIp(@RequestBody List<String> wxGroupIds);

    @ApiOperation(value = "通过群分类id获取微信群id", httpMethod = "GET")
    @RequestMapping(value = "getWxGroupId", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<String>> getWxGroupId(@RequestParam("classifyId") Long classifyId);

    @ApiOperation(value = "通过qrcodeId获取微信群信息", httpMethod = "GET")
    @RequestMapping(value = "getWxGroupInfoById", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<GroupQrcodeInfo4Advertising>> getWxGroupInfoById(@RequestParam("qrcodeId") Long qrcodeId);

    @ApiOperation(value = "通过qrcodeIds获取微信群信息", httpMethod = "POST")
    @RequestMapping(value = "getWxGroupInfoByIds", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<Long, GroupQrcodeInfo4Advertising>>> getWxGroupInfoByIds(@RequestBody List<Long> qrcodeIds);

    @ApiOperation(value = "修改模拟器IP地址", httpMethod = "GET")
    @RequestMapping(value = "updateGenerationMachineIp", method = RequestMethod.GET)
    void updateGenerationMachineIp(@RequestParam("generation") Integer generation, @RequestParam("machineIp") String machineIp);

    @ApiOperation(value = "根据条件获取待跟新二维码", httpMethod = "POST")
    @RequestMapping(value = "listUpdateQrByGeneration", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<List<UpdateQrDTO>>> listUpdateQrByGeneration(@RequestBody SearchDto searchDto);

    @ApiOperation("根据版本号列表获取机器人ip")
    @PostMapping("getRobotWxGroupIpByGeneration")
    ResponseEntity<ResponseDto<Map<Integer, String>>> getRobotWxGroupIpByGeneration(@RequestBody List<Integer> generations);

    @ApiOperation("根据版本号获取机器人ip")
    @GetMapping("getRobotIpByGeneration")
    ResponseEntity<ResponseDto<String>> getRobotIpByGeneration(@RequestParam("generation") Integer generation);

    @ApiOperation("安卓Hook拉取待更新群二维码")
    @RequestMapping(value = "/listQrCode4Android",method = RequestMethod.GET)
    ResponseEntity<ResponseDto<List<UpdateQrDTO>>> listQrCode4Android(@RequestParam("generation")Integer generation,@RequestParam("num")Integer num);

    @ApiOperation(value = "更新微信群素材",httpMethod = "POST")
    @RequestMapping(value = "/updateGroupMaterial",method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Integer>> updateGroupMaterial(@RequestBody List<String> groups);

    @ApiOperation(value = "迁移群素材到新的公众号 - 谨慎使用",httpMethod = "POST")
    @RequestMapping(value = "/migrateMaterial",method = RequestMethod.POST)
    ResponseEntity<ResponseDto<List<String>>> migrateMaterial(@RequestBody MaterialMigrateDTO migrateDTO);

    @ApiOperation(value = "旧数据处理 - 同步现有素材到新表[执行此方法之前，需要先关闭直接入群]")
    @RequestMapping(value = "syncGroupMaterial",method = RequestMethod.POST)
    void syncGroupMaterial(@RequestBody Map<String,Long> accountMap);

    @ApiOperation(value = "新增更新群的公众号", httpMethod = "GET")
    @RequestMapping(value = "/addAccount4Material", method = RequestMethod.GET)
    void addAccount4Material(@RequestParam("accountId") Long accountId, @RequestParam("useType") Integer useType);

    @ApiOperation("获取一个客服老师二维码")
    @GetMapping("getOneTeacherQrcode")
    ResponseEntity<ResponseDto<String>> getOneTeacherQrcode();

}
