package com.pcloud.book.skill.service;

import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.dto.GroupActivity4AppletDTO;
import com.pcloud.common.dto.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @Description：TODO
 * @Author：zy
 * @Date：2020-02-13
 * @Version：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifier = "skillServiceCloud", path = "/book/v1.0/skillService")
@Api(description = "技能内部接口")
public interface SkillService {

    @ApiOperation(value = "定时发送任务消息", httpMethod = "GET")
    @GetMapping("skillRemindMessage")
    void skillRemindMessage();


    @ApiOperation("获取社群map")
    @PostMapping("getGroupByIds")
    ResponseEntity<ResponseDto<Map<Long, GroupActivity4AppletDTO>>> getGroupByIds(@RequestBody List<Long> bookGroupClassifyIds, @RequestParam("groupType") Integer groupType);

}