package com.pcloud.book.advertising.biz;

import com.pcloud.book.advertising.dto.LinkRevertRecordDTO;
import com.pcloud.book.advertising.entity.AdvertisingLinkClick;
import com.pcloud.book.advertising.entity.AdvertisingLinkRevert;
import com.pcloud.common.page.PageBeanNew;

/**
 * @描述：链接转换
 * @作者：zhuyajie
 * @创建时间：16:58 2019/10/10
 * @版本：1.0
 */
public interface LinkRevertBiz {

    /**
     * 添加链接转换记录
     * @param advertisingLinkRevert
     * @return
     */
    Long addRevertRecord(AdvertisingLinkRevert advertisingLinkRevert);

    /**
     * 删除转换记录
     * @param id
     */
    void deleteRevertRecordById(Long id);

    /**
     * 分页查询转换记录
     * @param brandId
     * @return
     */
    PageBeanNew<LinkRevertRecordDTO> listPageRevertRecord(Long brandId, Integer currentPage, Integer numPerPage);

    /**
     * 转换记录列表导出
     * @param brandId
     */
    void exportRevertRecordList(Long brandId, Long partyId);

    /**
     * 添加链接点击记录
     * @param advertisingLinkClick
     * @return
     */
    void addClickRecord(AdvertisingLinkClick advertisingLinkClick);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    AdvertisingLinkRevert getById(Long id);

    /**
     * 统计昨日链接发送次数
     */
    void addYesterdaySendStatistic();

    /**
     * 修改链接数据变化值
     * @param linkRevert
     */
    void updateLinkBrandData(AdvertisingLinkRevert linkRevert);

}
