package com.pcloud.book.advertising.check;

import com.pcloud.book.advertising.entity.AdvertisingPlan;
import com.pcloud.book.advertising.entity.AdvertisingPut;
import com.pcloud.book.advertising.entity.AdvertisingPlanGroup;
import com.pcloud.book.advertising.enums.PutTypeEnum;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ListUtils;
import org.springframework.stereotype.Component;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/27 16:13
 **/
@Component("advertisingPlanCheck")
public class AdvertisingPlanCheck {

    @ParamLog("新增广告位计划参数校验")
    public void checkCreateAdvertisingPlan(AdvertisingPlan advertisingPlan) {
        if (ListUtils.isEmpty(advertisingPlan.getAdvertisingPuts())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "广告位定时投放不能为空！");
        }
        if (ListUtils.isEmpty(advertisingPlan.getAdvertisingPlanGroups())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "关联群不能为空！");
        }
        for (AdvertisingPut advertisingPut : advertisingPlan.getAdvertisingPuts()) {
            if (advertisingPut == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "广告位定时投放不能为空！");
            }
            if (advertisingPut.getAdvertisingSpaceId() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "广告位id不能为空！");
            }
            if (advertisingPut.getPutType() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "投放类型不能为空！");
            }
            if (advertisingPut.getPutTime() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "投放时间不能为空！");
            }
            if (PutTypeEnum.DAY.value.equals(advertisingPut.getPutType()) || PutTypeEnum.DAY.value.equals(advertisingPut.getPutType())) {
                if (advertisingPut.getStartTime() == null || advertisingPut.getEndTime() == null) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "开始时间结束时间不能为空！");
                }
            }
        }

        for (AdvertisingPlanGroup advertisingPutGroup : advertisingPlan.getAdvertisingPlanGroups()) {
            if (advertisingPutGroup == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "广告位计划关联不能为空！");
            }
            if (advertisingPutGroup.getBookId() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "bookId不能为空！");
            }
            if (advertisingPutGroup.getBookGroupId() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "bookGroupId不能为空！");
            }
            if (advertisingPutGroup.getClassifyId() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "分类不能为空！");
            }
            if (advertisingPutGroup.getQrcodeId() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "群id不能为空！");
            }
            if (advertisingPutGroup.getWeixinGroupId() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "微信群号不能为空！");
            }
        }


    }
}
