package com.pcloud.book.advertising.dao.impl;

import org.springframework.stereotype.Repository;
import com.pcloud.book.advertising.dao.AdvertisingAgentPermissionDao;
import com.pcloud.book.advertising.entity.AdvertisingAgentPermission;
import com.pcloud.common.core.dao.BaseDaoImpl;

import java.util.List;

/**
 * Description 广告位出版书刊权限数据访问层接口实现类
 * @author PENG
 * @date 2019/2/28
 */
@Repository("advertisingAgentPermissionDao")
public class AdvertisingAgentPermissionDaoImpl extends BaseDaoImpl<AdvertisingAgentPermission> implements AdvertisingAgentPermissionDao {

    /**
     * 获取出版社权限
     */
    @Override
    public AdvertisingAgentPermission getByAgentId(Long agentId) {
        return super.getSqlSession().selectOne(getStatement("getByAgentId"), agentId);
    }

    @Override
    public List<Long> getCloseAgentId() {
        return super.getSqlSession().selectList(getStatement("getCloseAgentId"));
    }
}
