package com.pcloud.book.appeal.facade.impl;

import com.pcloud.book.appeal.biz.BookAppealBiz;
import com.pcloud.book.appeal.dto.BookAppealDto;
import com.pcloud.book.appeal.entity.BookAppeal;
import com.pcloud.book.appeal.facade.BookAppealFacade;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.dto.BookMainAdviserDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.permission.Permission;
import com.pcloud.common.permission.PermissionCode.ServerPermissionCode;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;

/**
 * 书刊申诉接口实现
 * 
 * @author:lili
 * @date 创建时间：2017年3月30日 下午3:31:57
 * @version 1.0
 * @return
 */
@RequestMapping("/bookAppeal")
@RestController("bookAppealFacade")
public class BookAppealFacadeImpl implements BookAppealFacade {

	@Autowired
	private BookAppealBiz bookAppealBiz;

	/**
	 * 书刊申诉
	 */
	@Override
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public ResponseDto<BookAppealDto> create(@RequestHeader("token") String token, @RequestBody BookAppeal bookAppeal)
			throws BizException, PermissionException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookAppeal.setCreatedUser(adviserId);
		bookAppeal.setDeclarant(adviserId);
		bookAppealBiz.create(bookAppeal);
		return new ResponseDto<>(new BookAppealDto());

	}

	/**
	 * 申诉列表
	 */
	@Override
	@RequestMapping(value = "list", method = RequestMethod.GET)
	@Permission(Code = ServerPermissionCode.book+"bookAppeal/listPage")
	public ResponseDto<PageBean> list(@RequestHeader("token") String token,
			@RequestParam(value = "currentPage", required = false) Integer currentPage,
			@RequestParam(value = "numPerPage", required = false) Integer numPerPage,
			@RequestParam(value = "bookName", required = false) String bookName,
			@RequestParam(value = "appealState", required = false) Integer appealState)
			throws BizException, PermissionException {
		// token
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);

		if (currentPage == null || numPerPage == null || currentPage < 0 || numPerPage < 0) {
			throw BookBizException.PAGE_PARAM_DELETION;
		}

		return new ResponseDto<>(bookAppealBiz.list(new PageParam(currentPage, numPerPage), bookName, appealState));

	}

	/**
	 * 获取申诉详情
	 */
	@Override
	@RequestMapping(value = "getById", method = RequestMethod.GET)
	public ResponseDto<BookAppealDto> getById(@RequestHeader("token") String token,
			@RequestParam(value = "bookAppealId", required = false) Long bookAppealId)
			throws BizException, PermissionException {
		// token
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		BookAppealDto bookAppealDto = bookAppealBiz.getById(bookAppealId);
		return new ResponseDto<>(bookAppealDto == null ? new BookAppealDto() : bookAppealDto);

	}

	/**
	 * 申诉审核不通过
	 */
	@Override
	@RequestMapping(value = "setupAudit", method = RequestMethod.POST)
	public ResponseDto<?> setupAudit(@RequestHeader("token") String token, @RequestBody BookAppeal bookAppeal)
			throws BizException, PermissionException {
		// token
		Long auditUser = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookAppeal.setAuditUser(auditUser);
		bookAppeal.setLastModifiedUser(auditUser);
		bookAppealBiz.setupAudit(bookAppeal);
		return new ResponseDto<>();
	}

	/**
	 * 获取申诉编辑列表（申诉编辑+被诉编辑）
	 */
	@Override
	@RequestMapping(value = "getAppealAdvisers", method = RequestMethod.GET)
	public ResponseDto<?> getAppealAdvisers(@RequestHeader("token") String token,
			@RequestParam(value = "bookAppealId", required = false) Long bookAppealId)
			throws BizException, PermissionException {
		// token
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		return new ResponseDto<>(bookAppealBiz.getAppealAdvisers(bookAppealId));

	}

	/**
	 * 设置主编辑，申诉审核通过
	 */
	@Override
	@RequestMapping(value = "setMainAdviser", method = RequestMethod.POST)
	public ResponseDto<?> setMainAdviser(@RequestHeader("token") String token,
			@RequestBody BookMainAdviserDto bookMainAdviserDto)
			throws BizException, PermissionException{
		// token
		Long auditUser = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookAppealBiz.setMainAdviser(auditUser, bookMainAdviserDto);
		return new ResponseDto<>();
	}

	/**
	 * 获取申诉结果
	 */
	@Override
	@RequestMapping(value = "getAppealResult", method = RequestMethod.GET)
	public ResponseDto<?> getAppealResult(@RequestHeader("token") String token,
			@RequestParam(value = "bookAppealId") Long bookAppealId)
			throws BizException, PermissionException{
		// token
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		return new ResponseDto<>(bookAppealBiz.getAppealResult(bookAppealId));
	}

}
