package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.ReadBookRecordDTO;
import com.pcloud.book.applet.entity.ReadBookRecord;
import com.pcloud.common.page.PageBeanNew;

/**
 * (ReadBookRecord)表服务接口
 *
 * @author makejava
 * @since 2021-02-04 15:33:43
 */
public interface ReadBookRecordBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    ReadBookRecord getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param readBookRecord 实例对象
     * @return 主键
     */
    Long insert(ReadBookRecord readBookRecord);

    /**
     * 修改数据
     *
     * @param readBookRecord 实例对象
     */
    void update(ReadBookRecord readBookRecord);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 新增记录
     * @param readBookRecordDTO
     */
    Long addReadBookRecord(ReadBookRecordDTO readBookRecordDTO);

    /**
     * 定时任务从redis中删掉超时的本书服务记录
     */
    void autoDeleteReadBook();
}