package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.SpecialBookDTO;
import com.pcloud.book.applet.entity.SpecialBook;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

/**
 * (SpecialBook)表服务接口
 *
 * @author makejava
 * @since 2020-09-16 13:43:43
 */
public interface SpecialBookBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    SpecialBook getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param specialBook 实例对象
     * @return 主键
     */
    void insert(List<SpecialBook> specialBook);

    /**
     * 修改数据
     *
     * @param specialBook 实例对象
     */
    void update(SpecialBook specialBook);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 获取小睿统计书刊列表
     * @param queryName
     * @param startTime
     * @param endTime
     * @param currentPage
     * @param numPerPage
     * @param wechatUser
     * @return
     */
    PageBeanNew<SpecialBookDTO> listSpecialBook(String queryName, String startTime, String endTime, Integer currentPage, Integer numPerPage, String wechatUser);

    void exportSpecialBook(String queryName, String startTime, String endTime, Integer currentPage, Integer numPerPage, String wechatUser, Long partyId);

}