package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletNewsClassifyDTO;
import com.pcloud.book.applet.entity.AppletNewsClassify;
import com.pcloud.book.applet.entity.AppletNewsClassifyUser;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface AppletNewsClassifyDao extends BaseDao<AppletNewsClassify> {

    /**
     * 获取最大排序值
     * @return
     */
    Integer getMaxSeq(Long agentId);

    /**
     * 获取所有书单栏目
     * @return
     */
    List<AppletNewsClassifyDTO> getAllNewsClassify(Boolean showState, Long agentId);
    /**
     * 用户选择资讯栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:15
     *  * @param null
     */
    void batchInsertUserNewsClassify(List<AppletNewsClassifyUser> appletNewsClassifyUsers);

    /**
     * 用户删除资讯栏目
     *
     * @author：zhuyajie
     * @date：2020/5/14 11:15 * @param null
     */
    void deleteClassifyByWechatUesrId(Long wechatUserId);

    /**
     * 获取用户选择的资讯栏目id
     *
     * @author：zhuyajie
     * @date：2020/5/14 11:18 * @param null
     */
    List<Long> getClassifyIdsByUserId(Long wechatUserId);

    /**
     * 获取用户选择的资讯栏目
     *
     * @author：zhuyajie
     * @date：2020/5/14 11:32 * @param null
     */
    List<AppletNewsClassifyDTO> getClassifysByUserId(Long wechatUserId);
}
