package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletOuterBookDTO;
import com.pcloud.book.applet.dto.AppletOuterBooklistDTO;
import com.pcloud.book.applet.dto.OuterBooklistAddDTO;
import com.pcloud.book.applet.entity.AppletOuterBooklist;
import com.pcloud.common.core.dao.BaseDao;

import org.apache.ibatis.annotations.Param;
import java.util.List;
import java.util.Map;

/**
 * 外部书单(AppletOuterBooklist)表数据库访问层
 *
 * @author makejava
 * @since 2020-08-11 14:13:04
 */
public interface AppletOuterBooklistDao extends BaseDao<AppletOuterBooklist>{


    /**
     * 批量添加书刊
     * @author：zhuyajie
     * @date：2020/8/11 14:29
     *  * @param null
     */
    void addOuterBooklistConfig(List<OuterBooklistAddDTO> addDTOS);

    /**
     * 删除配置
     * @author：zhuyajie
     * @date：2020/8/11 14:30
     *  * @param null
     */
    void deleteConfigByOuterBooklistId(Long booklistId);

    /**
     * 根据书单id查书刊
     * @author：zhuyajie
     * @date：2020/8/11 16:04
     *  * @param null
     */
    List<Long> getBookIdsByBooklistId(Long booklistId);
    /**
     * 根据书刊id查书单数量
     * @author：zhuyajie
     * @date：2020/8/11 16:04
     *  * @param null
     */
    Integer getBooklistCountsByBookId(Long outerBookId);

    /**
     * 出版社列表
     * @author：zhuyajie
     * @date：2020/8/11 16:13
     *  * @param null
     */
    List<String> getOuterBooklistPublish(Long agentId);

    /**
     * 根据书单id查询图书
     * @author：zhuyajie
     * @date：2020/8/11 16:37
     *  * @param null
     */
    List<AppletOuterBookDTO> getBookListByBooklistId(Long booklistId);

    /**
     * 批量查书单
     * @author：zhuyajie
     * @date：2020/8/11 17:08
     *  * @param null
     */
    Map<Long,AppletOuterBooklistDTO> getByIds(List<Long> booklistIds);
    /**
     * 书单中删除书
     * @author：zhuyajie
     * @date：2020/8/12 17:26
     *  * @param null
     */
    void batchDeleteOuterBookFromBooklist(List<Long> configIds);

    /**
     * 更新书单删除状态
     * @param id
     */
    void updateDeleteState(Long id);

    /**
     * 更新外部书单
     * @param appletOuterBooklistDTO
     */
    void updateOuterBooklist(AppletOuterBooklistDTO appletOuterBooklistDTO);
}