package com.pcloud.book.applet.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.pcloud.book.applet.dao.AppletThirdResourcesClickDao;
import com.pcloud.book.applet.dto.AppletChartDateDTO;
import com.pcloud.book.applet.dto.PvuvDTO;
import com.pcloud.book.applet.entity.AppletThirdResourcesClick;
import com.pcloud.common.core.dao.BaseDaoImpl;

@Component
public class AppletThirdResourcesClickDaoImpl extends BaseDaoImpl<AppletThirdResourcesClick> implements
        AppletThirdResourcesClickDao {

    @Override
    public Map<Long, PvuvDTO> mapPVUV(Integer typeId, Integer recordType, List<Long> ids, Integer intervalDaya) {
        Map<String, Object> map = new HashMap<>();
        map.put("list", ids);
        map.put("recordType", recordType);
        map.put("typeId", typeId);
        map.put("intervalDaya", intervalDaya);
        return getSessionTemplate().selectMap(getStatement("mapPVUV"), map, "fromId");
    }

    @Override
    public List<AppletChartDateDTO> mapPVUVByMonth(Integer recordType, Long thirdResourcesId) {
        Map<String, Object> map = new HashMap<>();
        map.put("thirdResourcesId", thirdResourcesId);
        map.put("recordType", recordType);
        return getSessionTemplate().selectList(getStatement("mapPVUVByMonth"), map);
    }
}

