package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletUserDao;
import com.pcloud.book.applet.dto.AppletUserCountDTO;
import com.pcloud.book.applet.entity.AppletUser;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.applet.dao.impl.AppletUserDaoImpl
 * @Author zhuyajie
 * @Description 小程序用户
 * @Date 2020/7/28 17:36
 * @Version 1.0
 **/
@Component
public class AppletUserDaoImpl extends BaseDaoImpl<AppletUser> implements AppletUserDao {

    @Override
    public AppletUserCountDTO getUserCount(String startTime, String endTime, Long accountSettingId) {
        Map<String,Object> map = new HashMap<>();
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("accountSettingId", accountSettingId);
        return getSessionTemplate().selectOne(getStatement("getUserCount"), map);
    }
}
