package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.applet.entity.AppletThirdResources;
import com.pcloud.book.rightsSetting.entity.RightsNowItem;
import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.Date;

@Data
@ApiModel("小程序用户书架栏目")
public class AppletUserBookcaseDTO extends BaseDto {

    @ApiModelProperty("书架记录id")
    private Long id;

    @ApiModelProperty("图书id")
    private Long bookId;

    @ApiModelProperty("运营id")
    private Long channelId;

    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("书名")
    private String bookName;

    @ApiModelProperty("封面")
    private String coverImg;

    @ApiModelProperty("出版名称")
    private String agentName;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    protected Date createTime;

    @ApiModelProperty("作者")
    private String author;
    @ApiModelProperty("出版社")
    private String publish;
    @ApiModelProperty("一级分类id")
    private Long templetId;

    @ApiModelProperty("一级分类名称")
    private String templetName;

    @ApiModelProperty("二级分类id")
    private Long secondTempletId;

    @ApiModelProperty("三级分类id")
    private Long thirdTempletId;

    @ApiModelProperty("三级分类名称")
    private String thirdTempletName;

    @ApiModelProperty("二级分类名")
    private String secondTempletName;
    @ApiModelProperty("社群码类型")
    private Integer joinGroupType;
    @ApiModelProperty("小睿分类id")
    private Integer classifyId;

    @ApiModelProperty("isbn")
    private String isbn;

    @ApiModelProperty("年级标签")
    private Long gradeLabelId;

    @ApiModelProperty("科目标签")
    private Long subjectLabelId;

    @ApiModelProperty("上下册标签id")
    private Long volLabelId;

    /**
     * 版本标签id
     */
    private Long verLabelId;


    private Long  areaLabelId;


    @ApiModelProperty("社群书id")
    private Long bookGroupId;

    @ApiModelProperty("有关联社群")
    private Boolean hasGroup;
    @ApiModelProperty("权益id")
    private Long rightsSettingId;
    @ApiModelProperty("权益数量")
    private Integer rightsSettingCount;
    @ApiModelProperty("资源数量")
    private Integer resourceCount;
    @ApiModelProperty("书刊访问数量")
    private Integer bookUserCount;

    @ApiModelProperty("关联bookGroupId")
    private Long relatedBookGroupId;

    @ApiModelProperty("阅读导航是否打开")
    private Long guideIsOpen;

    @ApiModelProperty("阅读导航标题")
    private String guideTitle;

    @ApiModelProperty("阅读导航类型： NEWS 咨询  APP 小程序")
    private String guideType;

    @ApiModelProperty("导航关联id")
    private Long guideId;

    @ApiModelProperty("导航图片")
    private String guidePic;

    @ApiModelProperty("咨询对象")
    private RightsNowItem guideNewsItem;

    @ApiModelProperty("小程序对象")
    private AppletThirdResources guideAppletServe;

    @ApiModelProperty("应用或作品对象")
    private RightsNowItem guideAppItem;

    /**
     * 年级标签
     */
    private String graLabelName;

    /**
     * 科目标签
     */
    private String subLabelName;

    /**
     * 版本标签
     */
    private String verLabelName;

    /**
     * 地域标签
     */
    private String areaLabelName;
    /**
     * 上下册标签
     */
    private String volLabelName;
}
