package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ReadBookWeekStatisDTO {

    private Long wechatUserId;

    @ApiModelProperty("本周读书本数")
    private Integer readBookCount;

    @ApiModelProperty("本周已读新书本数")
    private Integer readNewBookCount;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    private List<ReadBookDayStatisDTO> readBookDayStatisList;
}
