package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.io.Serializable;

import lombok.Data;

/**
 * 小程序客户端书刊分类(AppletBookClassify)实体类
 *
 * @author makejava
 * @since 2020-05-15 16:10:59
 */
@Data
public class AppletBookClassify extends BaseEntity {
    private static final long serialVersionUID = 337057609923325418L;
    
    /**
    * 分类
    */
    private String classify;
    /**
    * 分类名称
    */
    private String classifyName;
    /**
    * 排序值
    */
    private Integer seq;
    /**
    * 图标
    */
    private String pic;
    /**
    * 客户端是否展示
    */
    private Boolean showState;
    /**
    * 创建时间
    */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
    * 修改时间
    */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;



}