package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * (AppletThirdResourcesStatic)实体类
 *
 * @author makejava
 * @since 2020-10-14 16:19:02
 */
@Data
public class AppletThirdResourcesStatic extends BaseEntity {

    private static final long serialVersionUID = -17545518067833673L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date date;

    @ApiModelProperty("学部(中文)")
    private String stageStr;

    @ApiModelProperty("学部(英文)")
    private String stage;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("备注")
    private String channelRemark;

    @ApiModelProperty("推送人数")
    private Integer pushUv;

    @ApiModelProperty("获取二维码人数")
    private Integer getQrCodeUv;

    @ApiModelProperty("长按扫码数")
    private Integer pressQrCodeUv;

    @ApiModelProperty("入群数")
    private Integer joinChatroomCount;

    @ApiModelProperty("入群率")
    private String joinChatroomRate;

    @ApiModelProperty("存留数")
    private Integer stayUserCount;

    private String shareRate;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("群类型")
    private Integer resourceType;

}