package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.BuyBookRequestBiz;
import com.pcloud.book.applet.dto.BuyBookRequestDTO;
import com.pcloud.book.applet.dto.BuyBookRequetUserDTO;
import com.pcloud.book.applet.entity.BuyBookRequest;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import com.pcloud.wechatgroup.message.enums.IsSystem;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * (BuyBookRequest)表控制层
 *
 * @author makejava
 * @since 2020-10-14 19:51:41
 */
@RestController("buyBookRequestFacade")
@RequestMapping("buyBookRequest")
public class BuyBookRequestFacade {

    @Autowired
    private BuyBookRequestBiz buyBookRequestBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@CookieValue("userInfo") String userInfo, @RequestParam Long id) throws BizException, PermissionException {
        return new ResponseDto<>(buyBookRequestBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage,
                                  @RequestParam(value = "agentId", required = false) Long agentId)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(buyBookRequestBiz.getList(currentPage, numPerPage, agentId));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@CookieValue("userInfo") String userInfo, @RequestBody BuyBookRequest buyBookRequest)
            throws BizException, PermissionException {
        Long miniWechatUserId = Cookie.getId(userInfo,"miniWechatUserId");
        Long officialAccountId = Cookie.getId(userInfo,Cookie._OFFICIAL_ACCOUNTS_ID);
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        buyBookRequest.setWechatUserId(wechatUserId);
        buyBookRequest.setMiniWechatUserId(miniWechatUserId);
        return new ResponseDto<>(buyBookRequestBiz.insert(buyBookRequest,officialAccountId));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@CookieValue("userInfo") String userInfo, @RequestBody BuyBookRequest buyBookRequest) throws BizException, PermissionException {
        buyBookRequestBiz.update(buyBookRequest);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        buyBookRequestBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("获取购书流程填写用户数量")
    @GetMapping("getUserCount")
    public ResponseDto<BuyBookRequetUserDTO> getUserCount(@CookieValue("userInfo") String userInfo, @RequestParam(value = "topCount", defaultValue = "5") Integer topCount) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<BuyBookRequetUserDTO>(buyBookRequestBiz.getUserCount(topCount));
    }

    @ApiOperation("导出购书申请")
    @GetMapping("exportRequestList")
    public ResponseDto<?> exportRequestList(@RequestHeader("token") String token,
                                            @RequestParam(value = "currentPage", required = false, defaultValue = "0") Integer currentPage,
                                            @RequestParam(value = "numPerPage", required = false, defaultValue = "100000") Integer numPerPage,
                                  @RequestParam(value = "agentId", required = false) Long agentId)
            throws BizException, PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        String isSystem = (String) map.get(SessionUtil.IS_SYSTEM);
        Long partyId = (Long) map.get(SessionUtil.PARTY_ID);
        if (IsSystem.NOT_SYSTEM.code.equals(isSystem)) {
            partyId = (Long) map.get(SessionUtil.MEMBER_ID);
        }
        buyBookRequestBiz.exportRequestList(agentId, currentPage, numPerPage, partyId);
        return new ResponseDto<>();
    }

    @ApiOperation("获取不同回复状态购书申请记录")
    @GetMapping("getByState")
    public ResponseDto<?> getByState(@CookieValue("userInfo") String userInfo,
                                     @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                     @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage,
                                     @RequestParam(value = "state",required = false) Integer state,
                                     @RequestParam(value = "requestEnv") Integer requestEvn){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(buyBookRequestBiz.getByState(currentPage,numPerPage,wechatUserId,state,requestEvn));
    }

    @ApiOperation("假删除数据")
    @GetMapping("fakeDelete")
    public ResponseDto<?> fakeDelete(@CookieValue("userInfo") String userInfo,
                                     @RequestParam("requestId") Long requestId){
        if (null == requestId) {
            throw BookBizException.PARAM_DELETION;
        }
        buyBookRequestBiz.fakeDelete(requestId);
        return new ResponseDto<>();
    }

    /**
     * 处理数据
     * @param token
     * @param open 为 1 更新删除状态为未删除
     *             和回复状态为未回复状态
     *             为 0 不更新着两个状态
     * @return
     */
    @ApiOperation("处理数据")
    @GetMapping("processingData")
    public ResponseDto<?> processingData(@RequestHeader("token")String token,
                                         @RequestParam(value = "open",required = false)int open){
        SessionUtil.getToken4Redis(token);
        buyBookRequestBiz.processingData(open);
        return new ResponseDto<>();
    }
}