package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.ReadBookRecordBiz;
import com.pcloud.book.applet.dto.ReadBookRecordDTO;
import com.pcloud.book.applet.entity.ReadBookRecord;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * (ReadBookRecord)表控制层
 *
 * @author makejava
 * @since 2021-02-04 15:33:44
 */
@RestController("readBookRecordFacade")
@RequestMapping("readBookRecord")
public class ReadBookRecordFacade {

    @Autowired
    private ReadBookRecordBiz readBookRecordBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(readBookRecordBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(readBookRecordBiz.getList(currentPage, numPerPage));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@RequestHeader("token") String token, @RequestBody ReadBookRecord readBookRecord)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(readBookRecordBiz.insert(readBookRecord));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token, @RequestBody ReadBookRecord readBookRecord) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        readBookRecordBiz.update(readBookRecord);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        readBookRecordBiz.deleteById(id);
        return new ResponseDto<>();
    }


    @ApiOperation("本书服务页阅读记录")
    @RequestMapping(value = "addReadBookRecord", method = RequestMethod.POST)
    public ResponseDto<Long> addReadBookRecord(@CookieValue("userInfo") String userInfo,
                                            @RequestBody ReadBookRecordDTO readBookRecordDTO){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        readBookRecordDTO.setWechatUserId(wechatUserId);
        return new ResponseDto<Long>( readBookRecordBiz.addReadBookRecord(readBookRecordDTO));
    }

}