package com.pcloud.book.book.biz.impl;

import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.book.book.biz.BookOtherBiz;
import com.pcloud.book.book.dao.BookAdviserDao;
import com.pcloud.book.book.dao.BookOtherDao;
import com.pcloud.book.book.entity.BookOther;
import com.pcloud.book.book.vo.PcloudAdviserBookVO;
import com.pcloud.book.rightsSetting.biz.RightsSettingBiz;
import com.pcloud.book.rightsSetting.dto.RightsSettingDto;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import static com.pcloud.book.util.common.ThreadPoolUtils.OTHER_POOL;

/**
 * (BookOther)表服务实现类
 *
 * @author makejava
 * @since 2020-12-02 18:51:00
 */
@Service("bookOtherBiz")
public class BookOtherBizImpl implements BookOtherBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(BookOtherBizImpl.class);

    @Autowired
    private BookOtherDao bookOtherDao;
    @Autowired
    private BookAdviserBiz bookAdviserBiz;
    @Autowired
    private BookAdviserDao bookAdviserDao;
    @Autowired
    private RightsSettingBiz rightsSettingBiz;

    @Override
    @ParamLog("通过ID查询单条数据")
    public BookOther getById(Long id) {
        return bookOtherDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = bookOtherDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(BookOther bookOther) {
        bookOtherDao.insert(bookOther);
        return bookOther.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(BookOther bookOther) {
        if (bookOther == null || !NumberUtil.isNumber(bookOther.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        bookOtherDao.update(bookOther);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        bookOtherDao.deleteById(id);
    }

    @Override
    public void getOtherBook() {
        OTHER_POOL.execute(()->{
            PageBeanNew<PcloudAdviserBookVO> pcloudAdviserBookVOPageBeanNew = bookAdviserBiz.listAdviserBook4Pcloud(null, 0, 100);
            Integer pageCount = pcloudAdviserBookVOPageBeanNew.getPageCount();
            List<PcloudAdviserBookVO> pcloudAdviserBookVOS  = new ArrayList<>();
            for (int i = 0; i < pageCount; i++) {
                pcloudAdviserBookVOPageBeanNew =  bookAdviserBiz.listAdviserBook4Pcloud(null, i, 100);
                if (null == pcloudAdviserBookVOPageBeanNew) {
                    continue;
                }
                pcloudAdviserBookVOS = pcloudAdviserBookVOPageBeanNew.getRecordList();
                if (ListUtils.isEmpty(pcloudAdviserBookVOS)) {
                    continue;
                }
                List<BookOther> bookOthers = new ArrayList<>();
                pcloudAdviserBookVOS.stream().forEach(pcloudAdviserBookVO ->  {
                    RightsSettingDto rightsSettingDto = rightsSettingBiz.getRightsSettingByBookId4AppletHome(pcloudAdviserBookVO.getBookId(),
                            pcloudAdviserBookVO.getAdviserId(), pcloudAdviserBookVO.getChannelId());
                    if (null == rightsSettingDto || null == rightsSettingDto.getId()) {
                        BookOther bookOther = new BookOther();
                        bookOther.setBookId(pcloudAdviserBookVO.getBookId());
                        bookOther.setAdviserId(pcloudAdviserBookVO.getAdviserId());
                        bookOther.setChannelId(pcloudAdviserBookVO.getChannelId());
                        bookOther.setBookName(pcloudAdviserBookVO.getBookName());
                        bookOthers.add(bookOther);
                    }
                });
                if (ListUtils.isEmpty(bookOthers)) {
                    continue;
                }
                bookOtherDao.insert(bookOthers);
                try {
                    Thread.sleep(1000 * 2);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}